%------------------------------------------------------------------------------
% File     : ITP088^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer KnowledgeKeysSecrets problem prob_351__3295008_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : KnowledgeKeysSecrets/prob_351__3295008_1 [Des21]

% Status   : Theorem
% Rating   : 0.33 v9.0.0, 0.00 v8.2.0, 0.33 v8.1.0, 0.25 v7.5.0
% Syntax   : Number of formulae    :  348 ( 115 unt;  67 typ;   0 def)
%            Number of atoms       : 1061 ( 289 equ;   0 cnn)
%            Maximal formula atoms :   13 (   3 avg)
%            Number of connectives : 4550 ( 216   ~;  34   |;  95   &;3653   @)
%                                         (   0 <=>; 552  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   20 (   8 avg)
%            Number of types       :    8 (   7 usr)
%            Number of type conns  :  167 ( 167   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   61 (  60 usr;   4 con; 0-6 aty)
%            Number of variables   : 1012 (  63   ^; 900   !;  29   ?;1012   :)
%                                         (  20  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:20:08.449
%------------------------------------------------------------------------------
% Could-be-implicit typings (9)
thf(ty_t_Secrecy__types_OExpression,type,
    secrecy_Expression: $tType ).

thf(ty_t_Secrecy__types_OSecrets,type,
    secrecy_Secrets: $tType ).

thf(ty_t_Secrecy__types_OspecID,type,
    secrecy_specID: $tType ).

thf(ty_t_Secrecy__types_OchanID,type,
    secrecy_chanID: $tType ).

thf(ty_t_Secrecy__types_OKeys,type,
    secrecy_Keys: $tType ).

thf(ty_t_Secrecy__types_OKS,type,
    secrecy_KS: $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

% Explicit typings (58)
thf(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Lattices_Obounded__semilattice__sup__bot,type,
    bounde1808546759up_bot: 
      !>[A: $tType] : $o ).

thf(sy_c_CompLocalSecrets_OLocalSecrets,type,
    localSecrets: secrecy_specID > ( set @ secrecy_KS ) ).

thf(sy_c_KnowledgeKeysSecrets__Mirabelle__khazhniute_OeoutKnowCorrect,type,
    knowle1667810483orrect: secrecy_specID > secrecy_KS > $o ).

thf(sy_c_KnowledgeKeysSecrets__Mirabelle__khazhniute_Oknow,type,
    knowle1437066798e_know: secrecy_specID > secrecy_KS > $o ).

thf(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_ListExtras_Omem,type,
    mem: 
      !>[A: $tType] : ( A > ( list @ A ) > $o ) ).

thf(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Secrecy_OcorrectCompositionKS,type,
    correctCompositionKS: secrecy_specID > $o ).

thf(sy_c_Secrecy_Oeout,type,
    eout: secrecy_specID > secrecy_Expression > $o ).

thf(sy_c_Secrecy_OeoutM,type,
    eoutM: secrecy_specID > ( set @ secrecy_chanID ) > secrecy_Expression > $o ).

thf(sy_c_Secrecy_OexprChannel,type,
    exprChannel: secrecy_chanID > secrecy_Expression > $o ).

thf(sy_c_Secrecy_Oine,type,
    ine: secrecy_specID > secrecy_Expression > $o ).

thf(sy_c_Secrecy_OineM,type,
    ineM: secrecy_specID > ( set @ secrecy_chanID ) > secrecy_Expression > $o ).

thf(sy_c_Secrecy_Oine__exprChannelSet,type,
    ine_exprChannelSet: secrecy_specID > ( set @ secrecy_chanID ) > secrecy_Expression > $o ).

thf(sy_c_Secrecy_Oine__exprChannelSingle,type,
    ine_ex1303305700Single: secrecy_specID > secrecy_chanID > secrecy_Expression > $o ).

thf(sy_c_Secrecy_OnotSpecKeysSecretsExpr,type,
    notSpe1586871396tsExpr: secrecy_specID > ( list @ secrecy_Expression ) > $o ).

thf(sy_c_Secrecy_Oout__exprChannelSet,type,
    out_exprChannelSet: secrecy_specID > ( set @ secrecy_chanID ) > secrecy_Expression > $o ).

thf(sy_c_Secrecy_Oout__exprChannelSingle,type,
    out_ex985543062Single: secrecy_specID > secrecy_chanID > secrecy_Expression > $o ).

thf(sy_c_Secrecy_OspecKeys,type,
    specKeys: secrecy_specID > ( set @ secrecy_Keys ) ).

thf(sy_c_Secrecy_OspecKeysSecrets,type,
    specKeysSecrets: secrecy_specID > ( set @ secrecy_KS ) ).

thf(sy_c_Secrecy_OspecSecrets,type,
    specSecrets: secrecy_specID > ( set @ secrecy_Secrets ) ).

thf(sy_c_Secrecy__types_OExpression_Ocase__Expression,type,
    secrec487562139ession: 
      !>[A: $tType] : ( ( secrecy_Keys > A ) > ( secrecy_Secrets > A ) > ( nat > A ) > ( secrecy_specID > A ) > secrecy_Expression > A ) ).

thf(sy_c_Secrecy__types_OExpression_OdE,type,
    secrecy_dE: nat > secrecy_Expression ).

thf(sy_c_Secrecy__types_OExpression_OidE,type,
    secrecy_idE: secrecy_specID > secrecy_Expression ).

thf(sy_c_Secrecy__types_OExpression_OkE,type,
    secrecy_kE: secrecy_Keys > secrecy_Expression ).

thf(sy_c_Secrecy__types_OExpression_Orec__Expression,type,
    secrec1231112373ession: 
      !>[A: $tType] : ( ( secrecy_Keys > A ) > ( secrecy_Secrets > A ) > ( nat > A ) > ( secrecy_specID > A ) > secrecy_Expression > A ) ).

thf(sy_c_Secrecy__types_OExpression_OsE,type,
    secrecy_sE: secrecy_Secrets > secrecy_Expression ).

thf(sy_c_Secrecy__types_OKS2Expression,type,
    secrec1016742679ession: secrecy_KS > secrecy_Expression ).

thf(sy_c_Secrecy__types_OKS_OkKS,type,
    secrecy_kKS: secrecy_Keys > secrecy_KS ).

thf(sy_c_Secrecy__types_OKS_OsKS,type,
    secrecy_sKS: secrecy_Secrets > secrecy_KS ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Ois__empty,type,
    is_empty: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Ois__singleton,type,
    is_singleton: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_inout_OcorrectCompositionIn,type,
    correctCompositionIn: secrecy_specID > $o ).

thf(sy_c_inout_OcorrectCompositionLoc,type,
    correc965049635ionLoc: secrecy_specID > $o ).

thf(sy_c_inout_OcorrectCompositionOut,type,
    correc990227761ionOut: secrecy_specID > $o ).

thf(sy_c_inout_OinStream,type,
    inStream: secrecy_specID > ( set @ secrecy_chanID ) > $o ).

thf(sy_c_inout_Oins,type,
    ins: secrecy_specID > ( set @ secrecy_chanID ) ).

thf(sy_c_inout_Oloc,type,
    loc: secrecy_specID > ( set @ secrecy_chanID ) ).

thf(sy_c_inout_OlocStream,type,
    locStream: secrecy_specID > ( set @ secrecy_chanID ) > $o ).

thf(sy_c_inout_Oout,type,
    out: secrecy_specID > ( set @ secrecy_chanID ) ).

thf(sy_c_inout_OoutStream,type,
    outStream: secrecy_specID > ( set @ secrecy_chanID ) > $o ).

thf(sy_c_inout_Osubcomponents,type,
    subcomponents: secrecy_specID > ( set @ secrecy_specID ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_P,type,
    p: secrecy_specID ).

thf(sy_v_PQ,type,
    pq: secrecy_specID ).

thf(sy_v_Q,type,
    q: secrecy_specID ).

thf(sy_v_key,type,
    key: secrecy_Keys ).

% Relevant facts (256)
thf(fact_0_assms_I4_J,axiom,
    correctCompositionIn @ pq ).

% assms(4)
thf(fact_1_assms_I2_J,axiom,
    ~ ( knowle1437066798e_know @ q @ ( secrecy_kKS @ key ) ) ).

% assms(2)
thf(fact_2_assms_I1_J,axiom,
    ~ ( knowle1437066798e_know @ p @ ( secrecy_kKS @ key ) ) ).

% assms(1)
thf(fact_3_assms_I3_J,axiom,
    ( ( subcomponents @ pq )
    = ( insert @ secrecy_specID @ p @ ( insert @ secrecy_specID @ q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) ) ).

% assms(3)
thf(fact_4_Expression_Oinject_I1_J,axiom,
    ! [X1: secrecy_Keys,Y1: secrecy_Keys] :
      ( ( ( secrecy_kE @ X1 )
        = ( secrecy_kE @ Y1 ) )
      = ( X1 = Y1 ) ) ).

% Expression.inject(1)
thf(fact_5_not__know__k__not__ine,axiom,
    ! [A2: secrecy_specID,M: secrecy_Keys] :
      ( ~ ( knowle1437066798e_know @ A2 @ ( secrecy_kKS @ M ) )
     => ~ ( ine @ A2 @ ( secrecy_kE @ M ) ) ) ).

% not_know_k_not_ine
thf(fact_6_know_Osimps_I1_J,axiom,
    ! [A2: secrecy_specID,M: secrecy_Keys] :
      ( ( knowle1437066798e_know @ A2 @ ( secrecy_kKS @ M ) )
      = ( ( ine @ A2 @ ( secrecy_kE @ M ) )
        | ( member @ secrecy_KS @ ( secrecy_kKS @ M ) @ ( localSecrets @ A2 ) ) ) ) ).

% know.simps(1)
thf(fact_7_Expression_Osimps_I21_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,F3: nat > A,F4: secrecy_specID > A,X1: secrecy_Keys] :
      ( ( secrec1231112373ession @ A @ F1 @ F2 @ F3 @ F4 @ ( secrecy_kE @ X1 ) )
      = ( F1 @ X1 ) ) ).

% Expression.simps(21)
thf(fact_8_Expression_Osimps_I17_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,F3: nat > A,F4: secrecy_specID > A,X1: secrecy_Keys] :
      ( ( secrec487562139ession @ A @ F1 @ F2 @ F3 @ F4 @ ( secrecy_kE @ X1 ) )
      = ( F1 @ X1 ) ) ).

% Expression.simps(17)
thf(fact_9_Expression_Odistinct_I5_J,axiom,
    ! [X1: secrecy_Keys,X4: secrecy_specID] :
      ( ( secrecy_kE @ X1 )
     != ( secrecy_idE @ X4 ) ) ).

% Expression.distinct(5)
thf(fact_10_Expression_Odistinct_I3_J,axiom,
    ! [X1: secrecy_Keys,X3: nat] :
      ( ( secrecy_kE @ X1 )
     != ( secrecy_dE @ X3 ) ) ).

% Expression.distinct(3)
thf(fact_11_KS2Expression_Osimps_I1_J,axiom,
    ! [M: secrecy_Keys] :
      ( ( secrec1016742679ession @ ( secrecy_kKS @ M ) )
      = ( secrecy_kE @ M ) ) ).

% KS2Expression.simps(1)
thf(fact_12_ineM__ine,axiom,
    ! [P: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression] :
      ( ( ineM @ P @ M2 @ E )
     => ( ine @ P @ E ) ) ).

% ineM_ine
thf(fact_13_not__ine__ineM,axiom,
    ! [P: secrecy_specID,E: secrecy_Expression,M2: set @ secrecy_chanID] :
      ( ~ ( ine @ P @ E )
     => ~ ( ineM @ P @ M2 @ E ) ) ).

% not_ine_ineM
thf(fact_14_LocalSecretsComposition__exprChannel__k,axiom,
    ! [X: secrecy_chanID,Keys: secrecy_Keys,P: secrecy_specID,Q: secrecy_specID] :
      ( ( exprChannel @ X @ ( secrecy_kE @ Keys ) )
     => ( ~ ( ine @ P @ ( secrecy_kE @ Keys ) )
       => ( ~ ( ine @ Q @ ( secrecy_kE @ Keys ) )
         => ( ~ ( member @ secrecy_chanID @ X @ ( ins @ P ) )
            & ~ ( member @ secrecy_chanID @ X @ ( ins @ Q ) ) ) ) ) ) ).

% LocalSecretsComposition_exprChannel_k
thf(fact_15_Expression_Odistinct_I1_J,axiom,
    ! [X1: secrecy_Keys,X2: secrecy_Secrets] :
      ( ( secrecy_kE @ X1 )
     != ( secrecy_sE @ X2 ) ) ).

% Expression.distinct(1)
thf(fact_16_KS_Oinject_I1_J,axiom,
    ! [X1: secrecy_Keys,Y1: secrecy_Keys] :
      ( ( ( secrecy_kKS @ X1 )
        = ( secrecy_kKS @ Y1 ) )
      = ( X1 = Y1 ) ) ).

% KS.inject(1)
thf(fact_17_Expression_Oinject_I2_J,axiom,
    ! [X2: secrecy_Secrets,Y2: secrecy_Secrets] :
      ( ( ( secrecy_sE @ X2 )
        = ( secrecy_sE @ Y2 ) )
      = ( X2 = Y2 ) ) ).

% Expression.inject(2)
thf(fact_18_Expression_Oinject_I4_J,axiom,
    ! [X4: secrecy_specID,Y4: secrecy_specID] :
      ( ( ( secrecy_idE @ X4 )
        = ( secrecy_idE @ Y4 ) )
      = ( X4 = Y4 ) ) ).

% Expression.inject(4)
thf(fact_19_Expression_Oinject_I3_J,axiom,
    ! [X3: nat,Y3: nat] :
      ( ( ( secrecy_dE @ X3 )
        = ( secrecy_dE @ Y3 ) )
      = ( X3 = Y3 ) ) ).

% Expression.inject(3)
thf(fact_20_Expression_Osimps_I24_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,F3: nat > A,F4: secrecy_specID > A,X4: secrecy_specID] :
      ( ( secrec1231112373ession @ A @ F1 @ F2 @ F3 @ F4 @ ( secrecy_idE @ X4 ) )
      = ( F4 @ X4 ) ) ).

% Expression.simps(24)
thf(fact_21_Expression_Osimps_I23_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,F3: nat > A,F4: secrecy_specID > A,X3: nat] :
      ( ( secrec1231112373ession @ A @ F1 @ F2 @ F3 @ F4 @ ( secrecy_dE @ X3 ) )
      = ( F3 @ X3 ) ) ).

% Expression.simps(23)
thf(fact_22_Expression_Osimps_I22_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,F3: nat > A,F4: secrecy_specID > A,X2: secrecy_Secrets] :
      ( ( secrec1231112373ession @ A @ F1 @ F2 @ F3 @ F4 @ ( secrecy_sE @ X2 ) )
      = ( F2 @ X2 ) ) ).

% Expression.simps(22)
thf(fact_23_Expression_Osimps_I20_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,F3: nat > A,F4: secrecy_specID > A,X4: secrecy_specID] :
      ( ( secrec487562139ession @ A @ F1 @ F2 @ F3 @ F4 @ ( secrecy_idE @ X4 ) )
      = ( F4 @ X4 ) ) ).

% Expression.simps(20)
thf(fact_24_Expression_Osimps_I19_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,F3: nat > A,F4: secrecy_specID > A,X3: nat] :
      ( ( secrec487562139ession @ A @ F1 @ F2 @ F3 @ F4 @ ( secrecy_dE @ X3 ) )
      = ( F3 @ X3 ) ) ).

% Expression.simps(19)
thf(fact_25_Expression_Osimps_I18_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,F3: nat > A,F4: secrecy_specID > A,X2: secrecy_Secrets] :
      ( ( secrec487562139ession @ A @ F1 @ F2 @ F3 @ F4 @ ( secrecy_sE @ X2 ) )
      = ( F2 @ X2 ) ) ).

% Expression.simps(18)
thf(fact_26_Expression_Odistinct_I11_J,axiom,
    ! [X3: nat,X4: secrecy_specID] :
      ( ( secrecy_dE @ X3 )
     != ( secrecy_idE @ X4 ) ) ).

% Expression.distinct(11)
thf(fact_27_Expression_Odistinct_I9_J,axiom,
    ! [X2: secrecy_Secrets,X4: secrecy_specID] :
      ( ( secrecy_sE @ X2 )
     != ( secrecy_idE @ X4 ) ) ).

% Expression.distinct(9)
thf(fact_28_Expression_Odistinct_I7_J,axiom,
    ! [X2: secrecy_Secrets,X3: nat] :
      ( ( secrecy_sE @ X2 )
     != ( secrecy_dE @ X3 ) ) ).

% Expression.distinct(7)
thf(fact_29_ineM__L1,axiom,
    ! [Ch: secrecy_chanID,M2: set @ secrecy_chanID,P: secrecy_specID,E: secrecy_Expression] :
      ( ( member @ secrecy_chanID @ Ch @ M2 )
     => ( ( member @ secrecy_chanID @ Ch @ ( ins @ P ) )
       => ( ( exprChannel @ Ch @ E )
         => ( ineM @ P @ M2 @ E ) ) ) ) ).

% ineM_L1
thf(fact_30_ine__def,axiom,
    ( ine
    = ( ^ [SP: secrecy_specID,E2: secrecy_Expression] :
        ? [Ch2: secrecy_chanID] :
          ( ( member @ secrecy_chanID @ Ch2 @ ( ins @ SP ) )
          & ( exprChannel @ Ch2 @ E2 ) ) ) ) ).

% ine_def
thf(fact_31_ineM__def,axiom,
    ( ineM
    = ( ^ [SP: secrecy_specID,M3: set @ secrecy_chanID,E2: secrecy_Expression] :
        ? [Ch2: secrecy_chanID] :
          ( ( member @ secrecy_chanID @ Ch2 @ ( ins @ SP ) )
          & ( member @ secrecy_chanID @ Ch2 @ M3 )
          & ( exprChannel @ Ch2 @ E2 ) ) ) ) ).

% ineM_def
thf(fact_32_TBlemma3b,axiom,
    ! [P: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID,Ch: secrecy_chanID] :
      ( ~ ( ineM @ P @ M2 @ E )
     => ( ~ ( ineM @ Q @ M2 @ E )
       => ( ( ( subcomponents @ PQ )
            = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
         => ( ( correctCompositionIn @ PQ )
           => ( ( member @ secrecy_chanID @ Ch @ M2 )
             => ( ( member @ secrecy_chanID @ Ch @ ( ins @ PQ ) )
               => ~ ( exprChannel @ Ch @ E ) ) ) ) ) ) ) ).

% TBlemma3b
thf(fact_33_TBtheorem1b,axiom,
    ! [PQ: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,P: secrecy_specID,Q: secrecy_specID] :
      ( ( ineM @ PQ @ M2 @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correctCompositionIn @ PQ )
         => ( ( ineM @ P @ M2 @ E )
            | ( ineM @ Q @ M2 @ E ) ) ) ) ) ).

% TBtheorem1b
thf(fact_34_TBtheorem3b,axiom,
    ! [P: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ~ ( ineM @ P @ M2 @ E )
     => ( ~ ( ineM @ Q @ M2 @ E )
       => ( ( ( subcomponents @ PQ )
            = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
         => ( ( correctCompositionIn @ PQ )
           => ~ ( ineM @ PQ @ M2 @ E ) ) ) ) ) ).

% TBtheorem3b
thf(fact_35_ine__ins__neg1,axiom,
    ! [P: secrecy_specID,M: secrecy_Expression,X: secrecy_chanID] :
      ( ~ ( ine @ P @ M )
     => ( ( exprChannel @ X @ M )
       => ~ ( member @ secrecy_chanID @ X @ ( ins @ P ) ) ) ) ).

% ine_ins_neg1
thf(fact_36_correctCompositionIn__L2,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Ch: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionIn @ PQ )
       => ( ( member @ secrecy_chanID @ Ch @ ( ins @ PQ ) )
         => ( ( member @ secrecy_chanID @ Ch @ ( ins @ P ) )
            | ( member @ secrecy_chanID @ Ch @ ( ins @ Q ) ) ) ) ) ) ).

% correctCompositionIn_L2
thf(fact_37_Expression_Oinduct,axiom,
    ! [P: secrecy_Expression > $o,Expression: secrecy_Expression] :
      ( ! [X5: secrecy_Keys] : ( P @ ( secrecy_kE @ X5 ) )
     => ( ! [X5: secrecy_Secrets] : ( P @ ( secrecy_sE @ X5 ) )
       => ( ! [X5: nat] : ( P @ ( secrecy_dE @ X5 ) )
         => ( ! [X5: secrecy_specID] : ( P @ ( secrecy_idE @ X5 ) )
           => ( P @ Expression ) ) ) ) ) ).

% Expression.induct
thf(fact_38_Expression_Oexhaust,axiom,
    ! [Y: secrecy_Expression] :
      ( ! [X12: secrecy_Keys] :
          ( Y
         != ( secrecy_kE @ X12 ) )
     => ( ! [X22: secrecy_Secrets] :
            ( Y
           != ( secrecy_sE @ X22 ) )
       => ( ! [X32: nat] :
              ( Y
             != ( secrecy_dE @ X32 ) )
         => ~ ! [X42: secrecy_specID] :
                ( Y
               != ( secrecy_idE @ X42 ) ) ) ) ) ).

% Expression.exhaust
thf(fact_39_correctCompositionIn__prop1,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,X: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionIn @ PQ )
       => ( ( member @ secrecy_chanID @ X @ ( ins @ PQ ) )
         => ( ( member @ secrecy_chanID @ X @ ( ins @ P ) )
            | ( member @ secrecy_chanID @ X @ ( ins @ Q ) ) ) ) ) ) ).

% correctCompositionIn_prop1
thf(fact_40_LocalSecretsComposition1,axiom,
    ! [Ls: secrecy_KS,P: secrecy_specID,PQ: secrecy_specID,Q: secrecy_specID] :
      ( ( member @ secrecy_KS @ Ls @ ( localSecrets @ P ) )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( member @ secrecy_KS @ Ls @ ( localSecrets @ PQ ) ) ) ) ).

% LocalSecretsComposition1
thf(fact_41_LocalSecretsComposition__exprChannel__s,axiom,
    ! [X: secrecy_chanID,Secrets: secrecy_Secrets,P: secrecy_specID,Q: secrecy_specID] :
      ( ( exprChannel @ X @ ( secrecy_sE @ Secrets ) )
     => ( ~ ( ine @ P @ ( secrecy_sE @ Secrets ) )
       => ( ~ ( ine @ Q @ ( secrecy_sE @ Secrets ) )
         => ( ~ ( member @ secrecy_chanID @ X @ ( ins @ P ) )
            & ~ ( member @ secrecy_chanID @ X @ ( ins @ Q ) ) ) ) ) ) ).

% LocalSecretsComposition_exprChannel_s
thf(fact_42_TBtheorem3a,axiom,
    ! [P: secrecy_specID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ~ ( ine @ P @ E )
     => ( ~ ( ine @ Q @ E )
       => ( ( ( subcomponents @ PQ )
            = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
         => ( ( correctCompositionIn @ PQ )
           => ~ ( ine @ PQ @ E ) ) ) ) ) ).

% TBtheorem3a
thf(fact_43_TBtheorem1a,axiom,
    ! [PQ: secrecy_specID,E: secrecy_Expression,P: secrecy_specID,Q: secrecy_specID] :
      ( ( ine @ PQ @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correctCompositionIn @ PQ )
         => ( ( ine @ P @ E )
            | ( ine @ Q @ E ) ) ) ) ) ).

% TBtheorem1a
thf(fact_44_singletonI,axiom,
    ! [A: $tType,A3: A] : ( member @ A @ A3 @ ( insert @ A @ A3 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singletonI
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A3: A,P: A > $o] :
      ( ( member @ A @ A3 @ ( collect @ A @ P ) )
      = ( P @ A3 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( collect @ A
        @ ^ [X6: A] : ( member @ A @ X6 @ A2 ) )
      = A2 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X5: A] :
          ( ( P @ X5 )
          = ( Q @ X5 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X5: A] :
          ( ( F @ X5 )
          = ( G @ X5 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_LocalSecretsComposition__neg1__k,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Keys: secrecy_Keys] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correc965049635ionLoc @ PQ )
       => ( ~ ( ine @ P @ ( secrecy_kE @ Keys ) )
         => ( ~ ( ine @ Q @ ( secrecy_kE @ Keys ) )
           => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Keys ) @ ( localSecrets @ P ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Keys ) @ ( localSecrets @ Q ) )
               => ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Keys ) @ ( localSecrets @ PQ ) ) ) ) ) ) ) ) ).

% LocalSecretsComposition_neg1_k
thf(fact_50_LocalSecretsComposition__ine2__k,axiom,
    ! [K: secrecy_Keys,PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID] :
      ( ( member @ secrecy_KS @ ( secrecy_kKS @ K ) @ ( localSecrets @ PQ ) )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc965049635ionLoc @ PQ )
         => ( ~ ( ine @ P @ ( secrecy_kE @ K ) )
           => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ K ) @ ( localSecrets @ P ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ K ) @ ( localSecrets @ Q ) )
               => ( ine @ Q @ ( secrecy_kE @ K ) ) ) ) ) ) ) ) ).

% LocalSecretsComposition_ine2_k
thf(fact_51_LocalSecretsComposition__ine1__k,axiom,
    ! [K: secrecy_Keys,PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID] :
      ( ( member @ secrecy_KS @ ( secrecy_kKS @ K ) @ ( localSecrets @ PQ ) )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc965049635ionLoc @ PQ )
         => ( ~ ( ine @ Q @ ( secrecy_kE @ K ) )
           => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ K ) @ ( localSecrets @ P ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ K ) @ ( localSecrets @ Q ) )
               => ( ine @ P @ ( secrecy_kE @ K ) ) ) ) ) ) ) ) ).

% LocalSecretsComposition_ine1_k
thf(fact_52_TBtheorem4b__P,axiom,
    ! [P: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,PQ: secrecy_specID,Q: secrecy_specID] :
      ( ( ineM @ P @ M2 @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correctCompositionIn @ PQ )
         => ( ? [Ch3: secrecy_chanID] :
                ( ( member @ secrecy_chanID @ Ch3 @ ( ins @ Q ) )
                & ( exprChannel @ Ch3 @ E )
                & ~ ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) )
                & ( member @ secrecy_chanID @ Ch3 @ M2 ) )
           => ( ineM @ PQ @ M2 @ E ) ) ) ) ) ).

% TBtheorem4b_P
thf(fact_53_TBtheorem4b__PQ,axiom,
    ! [P: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ( ( ineM @ P @ M2 @ E )
        | ( ineM @ Q @ M2 @ E ) )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correctCompositionIn @ PQ )
         => ( ? [Ch3: secrecy_chanID] :
                ( ( ( member @ secrecy_chanID @ Ch3 @ ( ins @ P ) )
                  | ( member @ secrecy_chanID @ Ch3 @ ( ins @ Q ) ) )
                & ( member @ secrecy_chanID @ Ch3 @ M2 )
                & ( exprChannel @ Ch3 @ E )
                & ~ ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) ) )
           => ( ineM @ PQ @ M2 @ E ) ) ) ) ) ).

% TBtheorem4b_PQ
thf(fact_54_TBtheorem4a__P,axiom,
    ! [P: secrecy_specID,E: secrecy_Expression,PQ: secrecy_specID,Q: secrecy_specID] :
      ( ( ine @ P @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correctCompositionIn @ PQ )
         => ( ? [Ch3: secrecy_chanID] :
                ( ( member @ secrecy_chanID @ Ch3 @ ( ins @ P ) )
                & ( exprChannel @ Ch3 @ E )
                & ~ ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) ) )
           => ( ine @ PQ @ E ) ) ) ) ) ).

% TBtheorem4a_P
thf(fact_55_TBtheorem4a__PQ,axiom,
    ! [P: secrecy_specID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ( ( ine @ P @ E )
        | ( ine @ Q @ E ) )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correctCompositionIn @ PQ )
         => ( ? [Ch3: secrecy_chanID] :
                ( ( ( member @ secrecy_chanID @ Ch3 @ ( ins @ P ) )
                  | ( member @ secrecy_chanID @ Ch3 @ ( ins @ Q ) ) )
                & ( exprChannel @ Ch3 @ E )
                & ~ ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) ) )
           => ( ine @ PQ @ E ) ) ) ) ) ).

% TBtheorem4a_PQ
thf(fact_56_insertCI,axiom,
    ! [A: $tType,A3: A,B2: set @ A,B3: A] :
      ( ( ~ ( member @ A @ A3 @ B2 )
       => ( A3 = B3 ) )
     => ( member @ A @ A3 @ ( insert @ A @ B3 @ B2 ) ) ) ).

% insertCI
thf(fact_57_insert__iff,axiom,
    ! [A: $tType,A3: A,B3: A,A2: set @ A] :
      ( ( member @ A @ A3 @ ( insert @ A @ B3 @ A2 ) )
      = ( ( A3 = B3 )
        | ( member @ A @ A3 @ A2 ) ) ) ).

% insert_iff
thf(fact_58_empty__Collect__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( collect @ A @ P ) )
      = ( ! [X6: A] :
            ~ ( P @ X6 ) ) ) ).

% empty_Collect_eq
thf(fact_59_Collect__empty__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ! [X6: A] :
            ~ ( P @ X6 ) ) ) ).

% Collect_empty_eq
thf(fact_60_all__not__in__conv,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( ! [X6: A] :
            ~ ( member @ A @ X6 @ A2 ) )
      = ( A2
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% all_not_in_conv
thf(fact_61_empty__iff,axiom,
    ! [A: $tType,C: A] :
      ~ ( member @ A @ C @ ( bot_bot @ ( set @ A ) ) ) ).

% empty_iff
thf(fact_62_insert__absorb2,axiom,
    ! [A: $tType,X: A,A2: set @ A] :
      ( ( insert @ A @ X @ ( insert @ A @ X @ A2 ) )
      = ( insert @ A @ X @ A2 ) ) ).

% insert_absorb2
thf(fact_63_TBtheorem4a__empty,axiom,
    ! [P: secrecy_specID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ( ( ine @ P @ E )
        | ( ine @ Q @ E ) )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correctCompositionIn @ PQ )
         => ( ( ( loc @ PQ )
              = ( bot_bot @ ( set @ secrecy_chanID ) ) )
           => ( ine @ PQ @ E ) ) ) ) ) ).

% TBtheorem4a_empty
thf(fact_64_ex__in__conv,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( ? [X6: A] : ( member @ A @ X6 @ A2 ) )
      = ( A2
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% ex_in_conv
thf(fact_65_equals0I,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ! [Y5: A] :
          ~ ( member @ A @ Y5 @ A2 )
     => ( A2
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% equals0I
thf(fact_66_equals0D,axiom,
    ! [A: $tType,A2: set @ A,A3: A] :
      ( ( A2
        = ( bot_bot @ ( set @ A ) ) )
     => ~ ( member @ A @ A3 @ A2 ) ) ).

% equals0D
thf(fact_67_emptyE,axiom,
    ! [A: $tType,A3: A] :
      ~ ( member @ A @ A3 @ ( bot_bot @ ( set @ A ) ) ) ).

% emptyE
thf(fact_68_mk__disjoint__insert,axiom,
    ! [A: $tType,A3: A,A2: set @ A] :
      ( ( member @ A @ A3 @ A2 )
     => ? [B4: set @ A] :
          ( ( A2
            = ( insert @ A @ A3 @ B4 ) )
          & ~ ( member @ A @ A3 @ B4 ) ) ) ).

% mk_disjoint_insert
thf(fact_69_insert__commute,axiom,
    ! [A: $tType,X: A,Y: A,A2: set @ A] :
      ( ( insert @ A @ X @ ( insert @ A @ Y @ A2 ) )
      = ( insert @ A @ Y @ ( insert @ A @ X @ A2 ) ) ) ).

% insert_commute
thf(fact_70_insert__eq__iff,axiom,
    ! [A: $tType,A3: A,A2: set @ A,B3: A,B2: set @ A] :
      ( ~ ( member @ A @ A3 @ A2 )
     => ( ~ ( member @ A @ B3 @ B2 )
       => ( ( ( insert @ A @ A3 @ A2 )
            = ( insert @ A @ B3 @ B2 ) )
          = ( ( ( A3 = B3 )
             => ( A2 = B2 ) )
            & ( ( A3 != B3 )
             => ? [C2: set @ A] :
                  ( ( A2
                    = ( insert @ A @ B3 @ C2 ) )
                  & ~ ( member @ A @ B3 @ C2 )
                  & ( B2
                    = ( insert @ A @ A3 @ C2 ) )
                  & ~ ( member @ A @ A3 @ C2 ) ) ) ) ) ) ) ).

% insert_eq_iff
thf(fact_71_insert__absorb,axiom,
    ! [A: $tType,A3: A,A2: set @ A] :
      ( ( member @ A @ A3 @ A2 )
     => ( ( insert @ A @ A3 @ A2 )
        = A2 ) ) ).

% insert_absorb
thf(fact_72_insert__ident,axiom,
    ! [A: $tType,X: A,A2: set @ A,B2: set @ A] :
      ( ~ ( member @ A @ X @ A2 )
     => ( ~ ( member @ A @ X @ B2 )
       => ( ( ( insert @ A @ X @ A2 )
            = ( insert @ A @ X @ B2 ) )
          = ( A2 = B2 ) ) ) ) ).

% insert_ident
thf(fact_73_Set_Oset__insert,axiom,
    ! [A: $tType,X: A,A2: set @ A] :
      ( ( member @ A @ X @ A2 )
     => ~ ! [B4: set @ A] :
            ( ( A2
              = ( insert @ A @ X @ B4 ) )
           => ( member @ A @ X @ B4 ) ) ) ).

% Set.set_insert
thf(fact_74_insertI2,axiom,
    ! [A: $tType,A3: A,B2: set @ A,B3: A] :
      ( ( member @ A @ A3 @ B2 )
     => ( member @ A @ A3 @ ( insert @ A @ B3 @ B2 ) ) ) ).

% insertI2
thf(fact_75_insertI1,axiom,
    ! [A: $tType,A3: A,B2: set @ A] : ( member @ A @ A3 @ ( insert @ A @ A3 @ B2 ) ) ).

% insertI1
thf(fact_76_insertE,axiom,
    ! [A: $tType,A3: A,B3: A,A2: set @ A] :
      ( ( member @ A @ A3 @ ( insert @ A @ B3 @ A2 ) )
     => ( ( A3 != B3 )
       => ( member @ A @ A3 @ A2 ) ) ) ).

% insertE
thf(fact_77_correctCompositionIn__L1,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Ch: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionIn @ PQ )
       => ( ~ ( member @ secrecy_chanID @ Ch @ ( loc @ PQ ) )
         => ( ( member @ secrecy_chanID @ Ch @ ( ins @ P ) )
           => ( member @ secrecy_chanID @ Ch @ ( ins @ PQ ) ) ) ) ) ) ).

% correctCompositionIn_L1
thf(fact_78_singleton__inject,axiom,
    ! [A: $tType,A3: A,B3: A] :
      ( ( ( insert @ A @ A3 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( A3 = B3 ) ) ).

% singleton_inject
thf(fact_79_insert__not__empty,axiom,
    ! [A: $tType,A3: A,A2: set @ A] :
      ( ( insert @ A @ A3 @ A2 )
     != ( bot_bot @ ( set @ A ) ) ) ).

% insert_not_empty
thf(fact_80_doubleton__eq__iff,axiom,
    ! [A: $tType,A3: A,B3: A,C: A,D: A] :
      ( ( ( insert @ A @ A3 @ ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
        = ( insert @ A @ C @ ( insert @ A @ D @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( ( ( A3 = C )
          & ( B3 = D ) )
        | ( ( A3 = D )
          & ( B3 = C ) ) ) ) ).

% doubleton_eq_iff
thf(fact_81_singleton__iff,axiom,
    ! [A: $tType,B3: A,A3: A] :
      ( ( member @ A @ B3 @ ( insert @ A @ A3 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( B3 = A3 ) ) ).

% singleton_iff
thf(fact_82_singletonD,axiom,
    ! [A: $tType,B3: A,A3: A] :
      ( ( member @ A @ B3 @ ( insert @ A @ A3 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( B3 = A3 ) ) ).

% singletonD
thf(fact_83_correctCompositionInLoc__exprChannel,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Ch: secrecy_chanID,M: secrecy_Expression] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionIn @ PQ )
       => ( ( member @ secrecy_chanID @ Ch @ ( ins @ P ) )
         => ( ( exprChannel @ Ch @ M )
           => ( ! [X5: secrecy_chanID] :
                  ( ( member @ secrecy_chanID @ X5 @ ( ins @ PQ ) )
                 => ~ ( exprChannel @ X5 @ M ) )
             => ( member @ secrecy_chanID @ Ch @ ( loc @ PQ ) ) ) ) ) ) ) ).

% correctCompositionInLoc_exprChannel
thf(fact_84_subcomponents__loc,axiom,
    ! [X: secrecy_specID] :
      ( ( correc965049635ionLoc @ X )
     => ( ( ( subcomponents @ X )
          = ( bot_bot @ ( set @ secrecy_specID ) ) )
       => ( ( loc @ X )
          = ( bot_bot @ ( set @ secrecy_chanID ) ) ) ) ) ).

% subcomponents_loc
thf(fact_85_TBtheorem4b__notP1,axiom,
    ! [P: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ( ineM @ P @ M2 @ E )
     => ( ~ ( ineM @ Q @ M2 @ E )
       => ( ( ( subcomponents @ PQ )
            = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
         => ( ( correctCompositionIn @ PQ )
           => ( ? [Ch3: secrecy_chanID] :
                  ( ( ine_ex1303305700Single @ P @ Ch3 @ E )
                  & ( member @ secrecy_chanID @ Ch3 @ M2 )
                  & ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) ) )
             => ~ ( ineM @ PQ @ M2 @ E ) ) ) ) ) ) ).

% TBtheorem4b_notP1
thf(fact_86_TBtheorem4a__notP1,axiom,
    ! [P: secrecy_specID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ( ine @ P @ E )
     => ( ~ ( ine @ Q @ E )
       => ( ( ( subcomponents @ PQ )
            = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
         => ( ( correctCompositionIn @ PQ )
           => ( ? [Ch3: secrecy_chanID] :
                  ( ( ine_ex1303305700Single @ P @ Ch3 @ E )
                  & ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) ) )
             => ~ ( ine @ PQ @ E ) ) ) ) ) ) ).

% TBtheorem4a_notP1
thf(fact_87_TBtheorem4b__notPQ,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,ChSetP: set @ secrecy_chanID,E: secrecy_Expression,ChSetQ: set @ secrecy_chanID,M2: set @ secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionIn @ PQ )
       => ( ( ine_exprChannelSet @ P @ ChSetP @ E )
         => ( ( ine_exprChannelSet @ Q @ ChSetQ @ E )
           => ( ! [X5: secrecy_chanID] :
                  ( ( member @ secrecy_chanID @ X5 @ ChSetP )
                 => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
             => ( ! [X5: secrecy_chanID] :
                    ( ( member @ secrecy_chanID @ X5 @ ChSetQ )
                   => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
               => ~ ( ineM @ PQ @ M2 @ E ) ) ) ) ) ) ) ).

% TBtheorem4b_notPQ
thf(fact_88_TBtheorem4b__notP2,axiom,
    ! [Q: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,PQ: secrecy_specID,P: secrecy_specID,ChSet: set @ secrecy_chanID] :
      ( ~ ( ineM @ Q @ M2 @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correctCompositionIn @ PQ )
         => ( ( ine_exprChannelSet @ P @ ChSet @ E )
           => ( ! [X5: secrecy_chanID] :
                  ( ( member @ secrecy_chanID @ X5 @ ChSet )
                 => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
             => ~ ( ineM @ PQ @ M2 @ E ) ) ) ) ) ) ).

% TBtheorem4b_notP2
thf(fact_89_TBtheorem4a__notPQ,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,ChSetP: set @ secrecy_chanID,E: secrecy_Expression,ChSetQ: set @ secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionIn @ PQ )
       => ( ( ine_exprChannelSet @ P @ ChSetP @ E )
         => ( ( ine_exprChannelSet @ Q @ ChSetQ @ E )
           => ( ! [X5: secrecy_chanID] :
                  ( ( member @ secrecy_chanID @ X5 @ ChSetP )
                 => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
             => ( ! [X5: secrecy_chanID] :
                    ( ( member @ secrecy_chanID @ X5 @ ChSetQ )
                   => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
               => ~ ( ine @ PQ @ E ) ) ) ) ) ) ) ).

% TBtheorem4a_notPQ
thf(fact_90_TBtheorem4a__notP2,axiom,
    ! [Q: secrecy_specID,E: secrecy_Expression,PQ: secrecy_specID,P: secrecy_specID,ChSet: set @ secrecy_chanID] :
      ( ~ ( ine @ Q @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correctCompositionIn @ PQ )
         => ( ( ine_exprChannelSet @ P @ ChSet @ E )
           => ( ! [X5: secrecy_chanID] :
                  ( ( member @ secrecy_chanID @ X5 @ ChSet )
                 => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
             => ~ ( ine @ PQ @ E ) ) ) ) ) ) ).

% TBtheorem4a_notP2
thf(fact_91_ine__exprChannelSet__Single,axiom,
    ! [P: secrecy_specID,Ch: secrecy_chanID,E: secrecy_Expression] :
      ( ( ine_exprChannelSet @ P @ ( insert @ secrecy_chanID @ Ch @ ( bot_bot @ ( set @ secrecy_chanID ) ) ) @ E )
     => ( ine_ex1303305700Single @ P @ Ch @ E ) ) ).

% ine_exprChannelSet_Single
thf(fact_92_ine__exprChannelSingle__Set,axiom,
    ! [P: secrecy_specID,Ch: secrecy_chanID,E: secrecy_Expression] :
      ( ( ine_ex1303305700Single @ P @ Ch @ E )
     => ( ine_exprChannelSet @ P @ ( insert @ secrecy_chanID @ Ch @ ( bot_bot @ ( set @ secrecy_chanID ) ) ) @ E ) ) ).

% ine_exprChannelSingle_Set
thf(fact_93_ine__nonempty__exprChannelSet,axiom,
    ! [P: secrecy_specID,ChSet: set @ secrecy_chanID,E: secrecy_Expression] :
      ( ( ine_exprChannelSet @ P @ ChSet @ E )
     => ( ( ChSet
         != ( bot_bot @ ( set @ secrecy_chanID ) ) )
       => ( ine @ P @ E ) ) ) ).

% ine_nonempty_exprChannelSet
thf(fact_94_ine__empty__exprChannelSet,axiom,
    ! [P: secrecy_specID,ChSet: set @ secrecy_chanID,E: secrecy_Expression] :
      ( ( ine_exprChannelSet @ P @ ChSet @ E )
     => ( ( ChSet
          = ( bot_bot @ ( set @ secrecy_chanID ) ) )
       => ~ ( ine @ P @ E ) ) ) ).

% ine_empty_exprChannelSet
thf(fact_95_ine__exprChannelSet__def,axiom,
    ( ine_exprChannelSet
    = ( ^ [SP: secrecy_specID,ChSet2: set @ secrecy_chanID,E2: secrecy_Expression] :
          ( ! [X6: secrecy_chanID] :
              ( ( member @ secrecy_chanID @ X6 @ ChSet2 )
             => ( ( member @ secrecy_chanID @ X6 @ ( ins @ SP ) )
                & ( exprChannel @ X6 @ E2 ) ) )
          & ! [X6: secrecy_chanID] :
              ( ( ~ ( member @ secrecy_chanID @ X6 @ ChSet2 )
                & ( member @ secrecy_chanID @ X6 @ ( ins @ SP ) ) )
             => ~ ( exprChannel @ X6 @ E2 ) ) ) ) ) ).

% ine_exprChannelSet_def
thf(fact_96_ine__exprChannelSingle__def,axiom,
    ( ine_ex1303305700Single
    = ( ^ [SP: secrecy_specID,Ch2: secrecy_chanID,E2: secrecy_Expression] :
          ( ( member @ secrecy_chanID @ Ch2 @ ( ins @ SP ) )
          & ( exprChannel @ Ch2 @ E2 )
          & ! [X6: secrecy_chanID,T: nat] :
              ( ( ( member @ secrecy_chanID @ X6 @ ( ins @ SP ) )
                & ( X6 != Ch2 ) )
             => ~ ( exprChannel @ X6 @ E2 ) ) ) ) ) ).

% ine_exprChannelSingle_def
thf(fact_97_LocalSecretsComposition__neg1,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Ks: secrecy_KS] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correc965049635ionLoc @ PQ )
       => ( ! [M4: secrecy_Keys] :
              ( ( Ks
                = ( secrecy_kKS @ M4 ) )
             => ( ~ ( ine @ P @ ( secrecy_kE @ M4 ) )
                & ~ ( ine @ Q @ ( secrecy_kE @ M4 ) ) ) )
         => ( ! [M4: secrecy_Secrets] :
                ( ( Ks
                  = ( secrecy_sKS @ M4 ) )
               => ( ~ ( ine @ P @ ( secrecy_sE @ M4 ) )
                  & ~ ( ine @ Q @ ( secrecy_sE @ M4 ) ) ) )
           => ( ~ ( member @ secrecy_KS @ Ks @ ( localSecrets @ P ) )
             => ( ~ ( member @ secrecy_KS @ Ks @ ( localSecrets @ Q ) )
               => ~ ( member @ secrecy_KS @ Ks @ ( localSecrets @ PQ ) ) ) ) ) ) ) ) ).

% LocalSecretsComposition_neg1
thf(fact_98_locStream__def,axiom,
    ( locStream
    = ( ^ [X6: secrecy_specID] :
          ( ^ [Y6: set @ secrecy_chanID,Z: set @ secrecy_chanID] : ( Y6 = Z )
          @ ( loc @ X6 ) ) ) ) ).

% locStream_def
thf(fact_99_inStream__def,axiom,
    ( inStream
    = ( ^ [X6: secrecy_specID] :
          ( ^ [Y6: set @ secrecy_chanID,Z: set @ secrecy_chanID] : ( Y6 = Z )
          @ ( ins @ X6 ) ) ) ) ).

% inStream_def
thf(fact_100_the__elem__eq,axiom,
    ! [A: $tType,X: A] :
      ( ( the_elem @ A @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
      = X ) ).

% the_elem_eq
thf(fact_101_bot__apply,axiom,
    ! [C3: $tType,D2: $tType] :
      ( ( bot @ C3 )
     => ( ( bot_bot @ ( D2 > C3 ) )
        = ( ^ [X6: D2] : ( bot_bot @ C3 ) ) ) ) ).

% bot_apply
thf(fact_102_LocalSecretsComposition__ine1__s,axiom,
    ! [S: secrecy_Secrets,PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID] :
      ( ( member @ secrecy_KS @ ( secrecy_sKS @ S ) @ ( localSecrets @ PQ ) )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc965049635ionLoc @ PQ )
         => ( ~ ( ine @ Q @ ( secrecy_sE @ S ) )
           => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ S ) @ ( localSecrets @ P ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ S ) @ ( localSecrets @ Q ) )
               => ( ine @ P @ ( secrecy_sE @ S ) ) ) ) ) ) ) ) ).

% LocalSecretsComposition_ine1_s
thf(fact_103_KS_Oinject_I2_J,axiom,
    ! [X2: secrecy_Secrets,Y2: secrecy_Secrets] :
      ( ( ( secrecy_sKS @ X2 )
        = ( secrecy_sKS @ Y2 ) )
      = ( X2 = Y2 ) ) ).

% KS.inject(2)
thf(fact_104_bot__set__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A @ ( bot_bot @ ( A > $o ) ) ) ) ).

% bot_set_def
thf(fact_105_KS_Oexhaust,axiom,
    ! [Y: secrecy_KS] :
      ( ! [X12: secrecy_Keys] :
          ( Y
         != ( secrecy_kKS @ X12 ) )
     => ~ ! [X22: secrecy_Secrets] :
            ( Y
           != ( secrecy_sKS @ X22 ) ) ) ).

% KS.exhaust
thf(fact_106_KS_Oinduct,axiom,
    ! [P: secrecy_KS > $o,KS: secrecy_KS] :
      ( ! [X5: secrecy_Keys] : ( P @ ( secrecy_kKS @ X5 ) )
     => ( ! [X5: secrecy_Secrets] : ( P @ ( secrecy_sKS @ X5 ) )
       => ( P @ KS ) ) ) ).

% KS.induct
thf(fact_107_KS_Odistinct_I1_J,axiom,
    ! [X1: secrecy_Keys,X2: secrecy_Secrets] :
      ( ( secrecy_kKS @ X1 )
     != ( secrecy_sKS @ X2 ) ) ).

% KS.distinct(1)
thf(fact_108_KS2Expression_Osimps_I2_J,axiom,
    ! [M: secrecy_Secrets] :
      ( ( secrec1016742679ession @ ( secrecy_sKS @ M ) )
      = ( secrecy_sE @ M ) ) ).

% KS2Expression.simps(2)
thf(fact_109_bot__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bot @ B )
     => ( ( bot_bot @ ( A > B ) )
        = ( ^ [X6: A] : ( bot_bot @ B ) ) ) ) ).

% bot_fun_def
thf(fact_110_not__know__s__not__ine,axiom,
    ! [A2: secrecy_specID,M: secrecy_Secrets] :
      ( ~ ( knowle1437066798e_know @ A2 @ ( secrecy_sKS @ M ) )
     => ~ ( ine @ A2 @ ( secrecy_sE @ M ) ) ) ).

% not_know_s_not_ine
thf(fact_111_know_Osimps_I2_J,axiom,
    ! [A2: secrecy_specID,M: secrecy_Secrets] :
      ( ( knowle1437066798e_know @ A2 @ ( secrecy_sKS @ M ) )
      = ( ( ine @ A2 @ ( secrecy_sE @ M ) )
        | ( member @ secrecy_KS @ ( secrecy_sKS @ M ) @ ( localSecrets @ A2 ) ) ) ) ).

% know.simps(2)
thf(fact_112_LocalSecretsComposition__neg1__s,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,S: secrecy_Secrets] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correc965049635ionLoc @ PQ )
       => ( ~ ( ine @ P @ ( secrecy_sE @ S ) )
         => ( ~ ( ine @ Q @ ( secrecy_sE @ S ) )
           => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ S ) @ ( localSecrets @ P ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ S ) @ ( localSecrets @ Q ) )
               => ~ ( member @ secrecy_KS @ ( secrecy_sKS @ S ) @ ( localSecrets @ PQ ) ) ) ) ) ) ) ) ).

% LocalSecretsComposition_neg1_s
thf(fact_113_LocalSecretsComposition__ine2__s,axiom,
    ! [S: secrecy_Secrets,PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID] :
      ( ( member @ secrecy_KS @ ( secrecy_sKS @ S ) @ ( localSecrets @ PQ ) )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc965049635ionLoc @ PQ )
         => ( ~ ( ine @ P @ ( secrecy_sE @ S ) )
           => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ S ) @ ( localSecrets @ P ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ S ) @ ( localSecrets @ Q ) )
               => ( ine @ Q @ ( secrecy_sE @ S ) ) ) ) ) ) ) ) ).

% LocalSecretsComposition_ine2_s
thf(fact_114_is__singleton__the__elem,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A4: set @ A] :
            ( A4
            = ( insert @ A @ ( the_elem @ A @ A4 ) @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_the_elem
thf(fact_115_is__singletonI,axiom,
    ! [A: $tType,X: A] : ( is_singleton @ A @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ).

% is_singletonI
thf(fact_116_LocalSecretsComposition__neg__loc__s,axiom,
    ! [Secret: secrecy_Secrets,P: secrecy_specID,Ch: secrecy_chanID] :
      ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ Secret ) @ ( localSecrets @ P ) )
     => ( ( exprChannel @ Ch @ ( secrecy_sE @ Secret ) )
       => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ Secret ) @ ( specKeysSecrets @ P ) )
         => ~ ( member @ secrecy_chanID @ Ch @ ( loc @ P ) ) ) ) ) ).

% LocalSecretsComposition_neg_loc_s
thf(fact_117_LocalSecretsComposition__neg__loc__k,axiom,
    ! [Key: secrecy_Keys,P: secrecy_specID,Ch: secrecy_chanID] :
      ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Key ) @ ( localSecrets @ P ) )
     => ( ( exprChannel @ Ch @ ( secrecy_kE @ Key ) )
       => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Key ) @ ( specKeysSecrets @ P ) )
         => ~ ( member @ secrecy_chanID @ Ch @ ( loc @ P ) ) ) ) ) ).

% LocalSecretsComposition_neg_loc_k
thf(fact_118_correctCompositionKS__exprChannel__s__Qex,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Secret: secrecy_Secrets,Ch: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ Secret ) @ ( localSecrets @ PQ ) )
         => ( ( member @ secrecy_chanID @ Ch @ ( ins @ Q ) )
           => ( ( exprChannel @ Ch @ ( secrecy_sE @ Secret ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ Secret ) @ ( specKeysSecrets @ PQ ) )
               => ( ( correctCompositionIn @ PQ )
                 => ? [Ch4: secrecy_chanID] :
                      ( ( member @ secrecy_chanID @ Ch4 @ ( ins @ PQ ) )
                      & ( exprChannel @ Ch4 @ ( secrecy_sE @ Secret ) ) ) ) ) ) ) ) ) ) ).

% correctCompositionKS_exprChannel_s_Qex
thf(fact_119_correctCompositionKS__PQ,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Ks: secrecy_KS] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ PQ ) )
         => ( ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ P ) )
            | ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ Q ) ) ) ) ) ) ).

% correctCompositionKS_PQ
thf(fact_120_correctCompositionKS__neg1,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Ks: secrecy_KS] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ~ ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ P ) )
         => ( ~ ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ Q ) )
           => ~ ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ PQ ) ) ) ) ) ) ).

% correctCompositionKS_neg1
thf(fact_121_correctCompositionKS__negP,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Ks: secrecy_KS] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ~ ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ PQ ) )
         => ~ ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ P ) ) ) ) ) ).

% correctCompositionKS_negP
thf(fact_122_correctCompositionKS__negQ,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Ks: secrecy_KS] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ~ ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ PQ ) )
         => ~ ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ Q ) ) ) ) ) ).

% correctCompositionKS_negQ
thf(fact_123_is__singletonI_H,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( A2
       != ( bot_bot @ ( set @ A ) ) )
     => ( ! [X5: A,Y5: A] :
            ( ( member @ A @ X5 @ A2 )
           => ( ( member @ A @ Y5 @ A2 )
             => ( X5 = Y5 ) ) )
       => ( is_singleton @ A @ A2 ) ) ) ).

% is_singletonI'
thf(fact_124_know__composition,axiom,
    ! [M: secrecy_KS,P: secrecy_specID,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ~ ( member @ secrecy_KS @ M @ ( specKeysSecrets @ P ) )
     => ( ~ ( member @ secrecy_KS @ M @ ( specKeysSecrets @ Q ) )
       => ( ( ( knowle1437066798e_know @ P @ M )
            | ( knowle1437066798e_know @ Q @ M ) )
         => ( ( ( subcomponents @ PQ )
              = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
           => ( ( correctCompositionIn @ PQ )
             => ( ( correctCompositionKS @ PQ )
               => ( knowle1437066798e_know @ PQ @ M ) ) ) ) ) ) ) ).

% know_composition
thf(fact_125_know__composition1,axiom,
    ! [M: secrecy_KS,P: secrecy_specID,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ~ ( member @ secrecy_KS @ M @ ( specKeysSecrets @ P ) )
     => ( ~ ( member @ secrecy_KS @ M @ ( specKeysSecrets @ Q ) )
       => ( ( knowle1437066798e_know @ P @ M )
         => ( ( ( subcomponents @ PQ )
              = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
           => ( ( correctCompositionIn @ PQ )
             => ( ( correctCompositionKS @ PQ )
               => ( knowle1437066798e_know @ PQ @ M ) ) ) ) ) ) ) ).

% know_composition1
thf(fact_126_know__composition2,axiom,
    ! [M: secrecy_KS,P: secrecy_specID,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ~ ( member @ secrecy_KS @ M @ ( specKeysSecrets @ P ) )
     => ( ~ ( member @ secrecy_KS @ M @ ( specKeysSecrets @ Q ) )
       => ( ( knowle1437066798e_know @ Q @ M )
         => ( ( ( subcomponents @ PQ )
              = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
           => ( ( correctCompositionIn @ PQ )
             => ( ( correctCompositionKS @ PQ )
               => ( knowle1437066798e_know @ PQ @ M ) ) ) ) ) ) ) ).

% know_composition2
thf(fact_127_is__singletonE,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( is_singleton @ A @ A2 )
     => ~ ! [X5: A] :
            ( A2
           != ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% is_singletonE
thf(fact_128_is__singleton__def,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A4: set @ A] :
          ? [X6: A] :
            ( A4
            = ( insert @ A @ X6 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_def
thf(fact_129_correctCompositionKS__exprChannel__k__P,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Key: secrecy_Keys,Ch: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Key ) @ ( localSecrets @ PQ ) )
         => ( ( member @ secrecy_chanID @ Ch @ ( ins @ P ) )
           => ( ( exprChannel @ Ch @ ( secrecy_kE @ Key ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Key ) @ ( specKeysSecrets @ PQ ) )
               => ( ( correctCompositionIn @ PQ )
                 => ( ( member @ secrecy_chanID @ Ch @ ( ins @ PQ ) )
                    & ( exprChannel @ Ch @ ( secrecy_kE @ Key ) ) ) ) ) ) ) ) ) ) ).

% correctCompositionKS_exprChannel_k_P
thf(fact_130_correctCompositionKS__exprChannel__k__Q,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Key: secrecy_Keys,Ch: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Key ) @ ( localSecrets @ PQ ) )
         => ( ( member @ secrecy_chanID @ Ch @ ( ins @ Q ) )
           => ( ( exprChannel @ Ch @ ( secrecy_kE @ Key ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Key ) @ ( specKeysSecrets @ PQ ) )
               => ( ( correctCompositionIn @ PQ )
                 => ( ( member @ secrecy_chanID @ Ch @ ( ins @ PQ ) )
                    & ( exprChannel @ Ch @ ( secrecy_kE @ Key ) ) ) ) ) ) ) ) ) ) ).

% correctCompositionKS_exprChannel_k_Q
thf(fact_131_correctCompositionKS__exprChannel__k__Pex,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Key: secrecy_Keys,Ch: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Key ) @ ( localSecrets @ PQ ) )
         => ( ( member @ secrecy_chanID @ Ch @ ( ins @ P ) )
           => ( ( exprChannel @ Ch @ ( secrecy_kE @ Key ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Key ) @ ( specKeysSecrets @ PQ ) )
               => ( ( correctCompositionIn @ PQ )
                 => ? [Ch4: secrecy_chanID] :
                      ( ( member @ secrecy_chanID @ Ch4 @ ( ins @ PQ ) )
                      & ( exprChannel @ Ch4 @ ( secrecy_kE @ Key ) ) ) ) ) ) ) ) ) ) ).

% correctCompositionKS_exprChannel_k_Pex
thf(fact_132_correctCompositionKS__exprChannel__k__Qex,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Key: secrecy_Keys,Ch: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Key ) @ ( localSecrets @ PQ ) )
         => ( ( member @ secrecy_chanID @ Ch @ ( ins @ Q ) )
           => ( ( exprChannel @ Ch @ ( secrecy_kE @ Key ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ Key ) @ ( specKeysSecrets @ PQ ) )
               => ( ( correctCompositionIn @ PQ )
                 => ? [Ch4: secrecy_chanID] :
                      ( ( member @ secrecy_chanID @ Ch4 @ ( ins @ PQ ) )
                      & ( exprChannel @ Ch4 @ ( secrecy_kE @ Key ) ) ) ) ) ) ) ) ) ) ).

% correctCompositionKS_exprChannel_k_Qex
thf(fact_133_correctCompositionKS__exprChannel__s__P,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Secret: secrecy_Secrets,Ch: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ Secret ) @ ( localSecrets @ PQ ) )
         => ( ( member @ secrecy_chanID @ Ch @ ( ins @ P ) )
           => ( ( exprChannel @ Ch @ ( secrecy_sE @ Secret ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ Secret ) @ ( specKeysSecrets @ PQ ) )
               => ( ( correctCompositionIn @ PQ )
                 => ( ( member @ secrecy_chanID @ Ch @ ( ins @ PQ ) )
                    & ( exprChannel @ Ch @ ( secrecy_sE @ Secret ) ) ) ) ) ) ) ) ) ) ).

% correctCompositionKS_exprChannel_s_P
thf(fact_134_correctCompositionKS__exprChannel__s__Q,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Secret: secrecy_Secrets,Ch: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ Secret ) @ ( localSecrets @ PQ ) )
         => ( ( member @ secrecy_chanID @ Ch @ ( ins @ Q ) )
           => ( ( exprChannel @ Ch @ ( secrecy_sE @ Secret ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ Secret ) @ ( specKeysSecrets @ PQ ) )
               => ( ( correctCompositionIn @ PQ )
                 => ( ( member @ secrecy_chanID @ Ch @ ( ins @ PQ ) )
                    & ( exprChannel @ Ch @ ( secrecy_sE @ Secret ) ) ) ) ) ) ) ) ) ) ).

% correctCompositionKS_exprChannel_s_Q
thf(fact_135_correctCompositionKS__exprChannel__s__Pex,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Secret: secrecy_Secrets,Ch: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correctCompositionKS @ PQ )
       => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ Secret ) @ ( localSecrets @ PQ ) )
         => ( ( member @ secrecy_chanID @ Ch @ ( ins @ P ) )
           => ( ( exprChannel @ Ch @ ( secrecy_sE @ Secret ) )
             => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ Secret ) @ ( specKeysSecrets @ PQ ) )
               => ( ( correctCompositionIn @ PQ )
                 => ? [Ch4: secrecy_chanID] :
                      ( ( member @ secrecy_chanID @ Ch4 @ ( ins @ PQ ) )
                      & ( exprChannel @ Ch4 @ ( secrecy_sE @ Secret ) ) ) ) ) ) ) ) ) ) ).

% correctCompositionKS_exprChannel_s_Pex
thf(fact_136_LocalSecretsComposition__neg,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,Ks: secrecy_KS] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correc965049635ionLoc @ PQ )
       => ( ( correctCompositionKS @ PQ )
         => ( ~ ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ P ) )
           => ( ~ ( member @ secrecy_KS @ Ks @ ( specKeysSecrets @ Q ) )
             => ( ! [M4: secrecy_Keys] :
                    ( ( Ks
                      = ( secrecy_kKS @ M4 ) )
                   => ( ~ ( ine @ P @ ( secrecy_kE @ M4 ) )
                      & ~ ( ine @ Q @ ( secrecy_kE @ M4 ) ) ) )
               => ( ! [M4: secrecy_Secrets] :
                      ( ( Ks
                        = ( secrecy_sKS @ M4 ) )
                     => ( ~ ( ine @ P @ ( secrecy_sE @ M4 ) )
                        & ~ ( ine @ Q @ ( secrecy_sE @ M4 ) ) ) )
                 => ( ~ ( member @ secrecy_KS @ Ks @ ( sup_sup @ ( set @ secrecy_KS ) @ ( localSecrets @ P ) @ ( localSecrets @ Q ) ) )
                   => ~ ( member @ secrecy_KS @ Ks @ ( localSecrets @ PQ ) ) ) ) ) ) ) ) ) ) ).

% LocalSecretsComposition_neg
thf(fact_137_LocalSecretsComposition__neg__s,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,M: secrecy_Secrets] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correc965049635ionLoc @ PQ )
       => ( ( correctCompositionKS @ PQ )
         => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ M ) @ ( specKeysSecrets @ P ) )
           => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ M ) @ ( specKeysSecrets @ Q ) )
             => ( ~ ( ine @ P @ ( secrecy_sE @ M ) )
               => ( ~ ( ine @ Q @ ( secrecy_sE @ M ) )
                 => ( ~ ( member @ secrecy_KS @ ( secrecy_sKS @ M ) @ ( sup_sup @ ( set @ secrecy_KS ) @ ( localSecrets @ P ) @ ( localSecrets @ Q ) ) )
                   => ~ ( member @ secrecy_KS @ ( secrecy_sKS @ M ) @ ( localSecrets @ PQ ) ) ) ) ) ) ) ) ) ) ).

% LocalSecretsComposition_neg_s
thf(fact_138_LocalSecretsComposition__neg__k,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,M: secrecy_Keys] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correc965049635ionLoc @ PQ )
       => ( ( correctCompositionKS @ PQ )
         => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ M ) @ ( specKeysSecrets @ P ) )
           => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ M ) @ ( specKeysSecrets @ Q ) )
             => ( ~ ( ine @ P @ ( secrecy_kE @ M ) )
               => ( ~ ( ine @ Q @ ( secrecy_kE @ M ) )
                 => ( ~ ( member @ secrecy_KS @ ( secrecy_kKS @ M ) @ ( sup_sup @ ( set @ secrecy_KS ) @ ( localSecrets @ P ) @ ( localSecrets @ Q ) ) )
                   => ~ ( member @ secrecy_KS @ ( secrecy_kKS @ M ) @ ( localSecrets @ PQ ) ) ) ) ) ) ) ) ) ) ).

% LocalSecretsComposition_neg_k
thf(fact_139_bot__empty__eq,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( A > $o ) )
      = ( ^ [X6: A] : ( member @ A @ X6 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% bot_empty_eq
thf(fact_140_UnCI,axiom,
    ! [A: $tType,C: A,B2: set @ A,A2: set @ A] :
      ( ( ~ ( member @ A @ C @ B2 )
       => ( member @ A @ C @ A2 ) )
     => ( member @ A @ C @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ) ).

% UnCI
thf(fact_141_Un__iff,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member @ A @ C @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
      = ( ( member @ A @ C @ A2 )
        | ( member @ A @ C @ B2 ) ) ) ).

% Un_iff
thf(fact_142_Un__empty,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( ( sup_sup @ ( set @ A ) @ A2 @ B2 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ( A2
          = ( bot_bot @ ( set @ A ) ) )
        & ( B2
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Un_empty
thf(fact_143_Un__insert__right,axiom,
    ! [A: $tType,A2: set @ A,A3: A,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( insert @ A @ A3 @ B2 ) )
      = ( insert @ A @ A3 @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ) ).

% Un_insert_right
thf(fact_144_Un__insert__left,axiom,
    ! [A: $tType,A3: A,B2: set @ A,C4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( insert @ A @ A3 @ B2 ) @ C4 )
      = ( insert @ A @ A3 @ ( sup_sup @ ( set @ A ) @ B2 @ C4 ) ) ) ).

% Un_insert_left
thf(fact_145_Un__empty__right,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( bot_bot @ ( set @ A ) ) )
      = A2 ) ).

% Un_empty_right
thf(fact_146_Un__empty__left,axiom,
    ! [A: $tType,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ B2 )
      = B2 ) ).

% Un_empty_left
thf(fact_147_UnE,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member @ A @ C @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
     => ( ~ ( member @ A @ C @ A2 )
       => ( member @ A @ C @ B2 ) ) ) ).

% UnE
thf(fact_148_UnI1,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member @ A @ C @ A2 )
     => ( member @ A @ C @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ) ).

% UnI1
thf(fact_149_UnI2,axiom,
    ! [A: $tType,C: A,B2: set @ A,A2: set @ A] :
      ( ( member @ A @ C @ B2 )
     => ( member @ A @ C @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ) ).

% UnI2
thf(fact_150_bex__Un,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,P: A > $o] :
      ( ( ? [X6: A] :
            ( ( member @ A @ X6 @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
            & ( P @ X6 ) ) )
      = ( ? [X6: A] :
            ( ( member @ A @ X6 @ A2 )
            & ( P @ X6 ) )
        | ? [X6: A] :
            ( ( member @ A @ X6 @ B2 )
            & ( P @ X6 ) ) ) ) ).

% bex_Un
thf(fact_151_ball__Un,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,P: A > $o] :
      ( ( ! [X6: A] :
            ( ( member @ A @ X6 @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
           => ( P @ X6 ) ) )
      = ( ! [X6: A] :
            ( ( member @ A @ X6 @ A2 )
           => ( P @ X6 ) )
        & ! [X6: A] :
            ( ( member @ A @ X6 @ B2 )
           => ( P @ X6 ) ) ) ) ).

% ball_Un
thf(fact_152_Un__assoc,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) @ C4 )
      = ( sup_sup @ ( set @ A ) @ A2 @ ( sup_sup @ ( set @ A ) @ B2 @ C4 ) ) ) ).

% Un_assoc
thf(fact_153_Un__absorb,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ A2 )
      = A2 ) ).

% Un_absorb
thf(fact_154_Un__commute,axiom,
    ! [A: $tType] :
      ( ( sup_sup @ ( set @ A ) )
      = ( ^ [A4: set @ A,B5: set @ A] : ( sup_sup @ ( set @ A ) @ B5 @ A4 ) ) ) ).

% Un_commute
thf(fact_155_Un__left__absorb,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
      = ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ).

% Un_left_absorb
thf(fact_156_Un__left__commute,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( sup_sup @ ( set @ A ) @ B2 @ C4 ) )
      = ( sup_sup @ ( set @ A ) @ B2 @ ( sup_sup @ ( set @ A ) @ A2 @ C4 ) ) ) ).

% Un_left_commute
thf(fact_157_singleton__Un__iff,axiom,
    ! [A: $tType,X: A,A2: set @ A,B2: set @ A] :
      ( ( ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) )
        = ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
      = ( ( ( A2
            = ( bot_bot @ ( set @ A ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) )
        | ( ( A2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( bot_bot @ ( set @ A ) ) ) )
        | ( ( A2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% singleton_Un_iff
thf(fact_158_Un__singleton__iff,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,X: A] :
      ( ( ( sup_sup @ ( set @ A ) @ A2 @ B2 )
        = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( ( A2
            = ( bot_bot @ ( set @ A ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) )
        | ( ( A2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( bot_bot @ ( set @ A ) ) ) )
        | ( ( A2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% Un_singleton_iff
thf(fact_159_insert__is__Un,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [A5: A] : ( sup_sup @ ( set @ A ) @ ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% insert_is_Un
thf(fact_160_sup__bot_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [A3: A] :
          ( ( sup_sup @ A @ A3 @ ( bot_bot @ A ) )
          = A3 ) ) ).

% sup_bot.right_neutral
thf(fact_161_sup__bot_Oneutr__eq__iff,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [A3: A,B3: A] :
          ( ( ( bot_bot @ A )
            = ( sup_sup @ A @ A3 @ B3 ) )
          = ( ( A3
              = ( bot_bot @ A ) )
            & ( B3
              = ( bot_bot @ A ) ) ) ) ) ).

% sup_bot.neutr_eq_iff
thf(fact_162_sup__bot_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [A3: A] :
          ( ( sup_sup @ A @ ( bot_bot @ A ) @ A3 )
          = A3 ) ) ).

% sup_bot.left_neutral
thf(fact_163_sup__bot_Oeq__neutr__iff,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [A3: A,B3: A] :
          ( ( ( sup_sup @ A @ A3 @ B3 )
            = ( bot_bot @ A ) )
          = ( ( A3
              = ( bot_bot @ A ) )
            & ( B3
              = ( bot_bot @ A ) ) ) ) ) ).

% sup_bot.eq_neutr_iff
thf(fact_164_sup__bot__left,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [X: A] :
          ( ( sup_sup @ A @ ( bot_bot @ A ) @ X )
          = X ) ) ).

% sup_bot_left
thf(fact_165_sup__bot__right,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [X: A] :
          ( ( sup_sup @ A @ X @ ( bot_bot @ A ) )
          = X ) ) ).

% sup_bot_right
thf(fact_166_bot__eq__sup__iff,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [X: A,Y: A] :
          ( ( ( bot_bot @ A )
            = ( sup_sup @ A @ X @ Y ) )
          = ( ( X
              = ( bot_bot @ A ) )
            & ( Y
              = ( bot_bot @ A ) ) ) ) ) ).

% bot_eq_sup_iff
thf(fact_167_sup__eq__bot__iff,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A )
     => ! [X: A,Y: A] :
          ( ( ( sup_sup @ A @ X @ Y )
            = ( bot_bot @ A ) )
          = ( ( X
              = ( bot_bot @ A ) )
            & ( Y
              = ( bot_bot @ A ) ) ) ) ) ).

% sup_eq_bot_iff
thf(fact_168_ineM__Un1,axiom,
    ! [P: secrecy_specID,A2: set @ secrecy_chanID,E: secrecy_Expression,B2: set @ secrecy_chanID] :
      ( ( ineM @ P @ A2 @ E )
     => ( ineM @ P @ ( sup_sup @ ( set @ secrecy_chanID ) @ A2 @ B2 ) @ E ) ) ).

% ineM_Un1
thf(fact_169_Collect__empty__eq__bot,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( P
        = ( bot_bot @ ( A > $o ) ) ) ) ).

% Collect_empty_eq_bot
thf(fact_170_notSpecKeysSecretsExpr__def,axiom,
    ( notSpe1586871396tsExpr
    = ( ^ [P2: secrecy_specID,E3: list @ secrecy_Expression] :
          ( ! [X6: secrecy_Keys] :
              ( ( mem @ secrecy_Expression @ ( secrecy_kE @ X6 ) @ E3 )
             => ~ ( member @ secrecy_KS @ ( secrecy_kKS @ X6 ) @ ( specKeysSecrets @ P2 ) ) )
          & ! [Y7: secrecy_Secrets] :
              ( ( mem @ secrecy_Expression @ ( secrecy_sE @ Y7 ) @ E3 )
             => ~ ( member @ secrecy_KS @ ( secrecy_sKS @ Y7 ) @ ( specKeysSecrets @ P2 ) ) ) ) ) ) ).

% notSpecKeysSecretsExpr_def
thf(fact_171_Set_Ois__empty__def,axiom,
    ! [A: $tType] :
      ( ( is_empty @ A )
      = ( ^ [A4: set @ A] :
            ( A4
            = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Set.is_empty_def
thf(fact_172_TBtheorem5a__empty,axiom,
    ! [P: secrecy_specID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ( ( eout @ P @ E )
        | ( eout @ Q @ E ) )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc990227761ionOut @ PQ )
         => ( ( ( loc @ PQ )
              = ( bot_bot @ ( set @ secrecy_chanID ) ) )
           => ( eout @ PQ @ E ) ) ) ) ) ).

% TBtheorem5a_empty
thf(fact_173_correctCompositionKS__subcomp1,axiom,
    ! [C4: secrecy_specID,X: secrecy_specID,Xa: secrecy_Keys] :
      ( ( correctCompositionKS @ C4 )
     => ( ( member @ secrecy_specID @ X @ ( subcomponents @ C4 ) )
       => ( ( member @ secrecy_Keys @ Xa @ ( specKeys @ C4 ) )
         => ? [X5: secrecy_specID] :
              ( ( member @ secrecy_specID @ X5 @ ( subcomponents @ C4 ) )
              & ( member @ secrecy_Keys @ Xa @ ( specKeys @ X5 ) ) ) ) ) ) ).

% correctCompositionKS_subcomp1
thf(fact_174_correctCompositionKS__subcomp2,axiom,
    ! [C4: secrecy_specID,X: secrecy_specID,Xa: secrecy_Secrets] :
      ( ( correctCompositionKS @ C4 )
     => ( ( member @ secrecy_specID @ X @ ( subcomponents @ C4 ) )
       => ( ( member @ secrecy_Secrets @ Xa @ ( specSecrets @ C4 ) )
         => ? [X5: secrecy_specID] :
              ( ( member @ secrecy_specID @ X5 @ ( subcomponents @ C4 ) )
              & ( member @ secrecy_Secrets @ Xa @ ( specSecrets @ X5 ) ) ) ) ) ) ).

% correctCompositionKS_subcomp2
thf(fact_175_TBtheorem2a,axiom,
    ! [PQ: secrecy_specID,E: secrecy_Expression,P: secrecy_specID,Q: secrecy_specID] :
      ( ( eout @ PQ @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc990227761ionOut @ PQ )
         => ( ( eout @ P @ E )
            | ( eout @ Q @ E ) ) ) ) ) ).

% TBtheorem2a
thf(fact_176_correctCompositionKS__subcomp4,axiom,
    ! [C4: secrecy_specID,X: secrecy_specID,Xa: secrecy_Secrets] :
      ( ( correctCompositionKS @ C4 )
     => ( ( member @ secrecy_specID @ X @ ( subcomponents @ C4 ) )
       => ( ( member @ secrecy_Secrets @ Xa @ ( specSecrets @ X ) )
         => ( member @ secrecy_Secrets @ Xa @ ( specSecrets @ C4 ) ) ) ) ) ).

% correctCompositionKS_subcomp4
thf(fact_177_correctCompositionKS__subcomp3,axiom,
    ! [C4: secrecy_specID,X: secrecy_specID,Xa: secrecy_Keys] :
      ( ( correctCompositionKS @ C4 )
     => ( ( member @ secrecy_specID @ X @ ( subcomponents @ C4 ) )
       => ( ( member @ secrecy_Keys @ Xa @ ( specKeys @ X ) )
         => ( member @ secrecy_Keys @ Xa @ ( specKeys @ C4 ) ) ) ) ) ).

% correctCompositionKS_subcomp3
thf(fact_178_TBtheorem5a__notP1,axiom,
    ! [P: secrecy_specID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ( eout @ P @ E )
     => ( ~ ( eout @ Q @ E )
       => ( ( ( subcomponents @ PQ )
            = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
         => ( ( correc990227761ionOut @ PQ )
           => ( ? [Ch3: secrecy_chanID] :
                  ( ( out_ex985543062Single @ P @ Ch3 @ E )
                  & ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) ) )
             => ~ ( eout @ PQ @ E ) ) ) ) ) ) ).

% TBtheorem5a_notP1
thf(fact_179_TBtheorem5a__notP2,axiom,
    ! [Q: secrecy_specID,E: secrecy_Expression,PQ: secrecy_specID,P: secrecy_specID,ChSet: set @ secrecy_chanID] :
      ( ~ ( eout @ Q @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc990227761ionOut @ PQ )
         => ( ( out_exprChannelSet @ P @ ChSet @ E )
           => ( ! [X5: secrecy_chanID] :
                  ( ( member @ secrecy_chanID @ X5 @ ChSet )
                 => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
             => ~ ( eout @ PQ @ E ) ) ) ) ) ) ).

% TBtheorem5a_notP2
thf(fact_180_TBtheorem5a__notPQ,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,ChSetP: set @ secrecy_chanID,E: secrecy_Expression,ChSetQ: set @ secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correc990227761ionOut @ PQ )
       => ( ( out_exprChannelSet @ P @ ChSetP @ E )
         => ( ( out_exprChannelSet @ Q @ ChSetQ @ E )
           => ( ! [X5: secrecy_chanID] :
                  ( ( member @ secrecy_chanID @ X5 @ ChSetP )
                 => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
             => ( ! [X5: secrecy_chanID] :
                    ( ( member @ secrecy_chanID @ X5 @ ChSetQ )
                   => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
               => ~ ( eout @ PQ @ E ) ) ) ) ) ) ) ).

% TBtheorem5a_notPQ
thf(fact_181_out__exprChannelSingle__Set,axiom,
    ! [P: secrecy_specID,Ch: secrecy_chanID,E: secrecy_Expression] :
      ( ( out_ex985543062Single @ P @ Ch @ E )
     => ( out_exprChannelSet @ P @ ( insert @ secrecy_chanID @ Ch @ ( bot_bot @ ( set @ secrecy_chanID ) ) ) @ E ) ) ).

% out_exprChannelSingle_Set
thf(fact_182_out__exprChannelSet__Single,axiom,
    ! [P: secrecy_specID,Ch: secrecy_chanID,E: secrecy_Expression] :
      ( ( out_exprChannelSet @ P @ ( insert @ secrecy_chanID @ Ch @ ( bot_bot @ ( set @ secrecy_chanID ) ) ) @ E )
     => ( out_ex985543062Single @ P @ Ch @ E ) ) ).

% out_exprChannelSet_Single
thf(fact_183_TBtheorem5b__notPQ,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,ChSetP: set @ secrecy_chanID,E: secrecy_Expression,ChSetQ: set @ secrecy_chanID,M2: set @ secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correc990227761ionOut @ PQ )
       => ( ( out_exprChannelSet @ P @ ChSetP @ E )
         => ( ( out_exprChannelSet @ Q @ ChSetQ @ E )
           => ( ( M2
                = ( sup_sup @ ( set @ secrecy_chanID ) @ ChSetP @ ChSetQ ) )
             => ( ! [X5: secrecy_chanID] :
                    ( ( member @ secrecy_chanID @ X5 @ ChSetP )
                   => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
               => ( ! [X5: secrecy_chanID] :
                      ( ( member @ secrecy_chanID @ X5 @ ChSetQ )
                     => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
                 => ~ ( eoutM @ PQ @ M2 @ E ) ) ) ) ) ) ) ) ).

% TBtheorem5b_notPQ
thf(fact_184_eout__know__s,axiom,
    ! [C4: secrecy_specID,M: secrecy_Secrets] :
      ( ( knowle1667810483orrect @ C4 @ ( secrecy_sKS @ M ) )
      = ( ( eout @ C4 @ ( secrecy_sE @ M ) )
        = ( ( member @ secrecy_Secrets @ M @ ( specSecrets @ C4 ) )
          | ( knowle1437066798e_know @ C4 @ ( secrecy_sKS @ M ) ) ) ) ) ).

% eout_know_s
thf(fact_185_not__know__s__not__eout,axiom,
    ! [M: secrecy_Secrets,A2: secrecy_specID] :
      ( ~ ( member @ secrecy_Secrets @ M @ ( specSecrets @ A2 ) )
     => ( ~ ( knowle1437066798e_know @ A2 @ ( secrecy_sKS @ M ) )
       => ( ( knowle1667810483orrect @ A2 @ ( secrecy_sKS @ M ) )
         => ~ ( eout @ A2 @ ( secrecy_sE @ M ) ) ) ) ) ).

% not_know_s_not_eout
thf(fact_186_eoutM__eout,axiom,
    ! [P: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression] :
      ( ( eoutM @ P @ M2 @ E )
     => ( eout @ P @ E ) ) ).

% eoutM_eout
thf(fact_187_not__eout__eoutM,axiom,
    ! [P: secrecy_specID,E: secrecy_Expression,M2: set @ secrecy_chanID] :
      ( ~ ( eout @ P @ E )
     => ~ ( eoutM @ P @ M2 @ E ) ) ).

% not_eout_eoutM
thf(fact_188_TBtheorem2b,axiom,
    ! [PQ: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,P: secrecy_specID,Q: secrecy_specID] :
      ( ( eoutM @ PQ @ M2 @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc990227761ionOut @ PQ )
         => ( ( eoutM @ P @ M2 @ E )
            | ( eoutM @ Q @ M2 @ E ) ) ) ) ) ).

% TBtheorem2b
thf(fact_189_TBtheorem5b__notP2,axiom,
    ! [Q: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,PQ: secrecy_specID,P: secrecy_specID,ChSet: set @ secrecy_chanID] :
      ( ~ ( eoutM @ Q @ M2 @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc990227761ionOut @ PQ )
         => ( ( out_exprChannelSet @ P @ ChSet @ E )
           => ( ! [X5: secrecy_chanID] :
                  ( ( member @ secrecy_chanID @ X5 @ ChSet )
                 => ( member @ secrecy_chanID @ X5 @ ( loc @ PQ ) ) )
             => ~ ( eoutM @ PQ @ M2 @ E ) ) ) ) ) ) ).

% TBtheorem5b_notP2
thf(fact_190_TBtheorem5b__notP1,axiom,
    ! [P: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ( eoutM @ P @ M2 @ E )
     => ( ~ ( eoutM @ Q @ M2 @ E )
       => ( ( ( subcomponents @ PQ )
            = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
         => ( ( correc990227761ionOut @ PQ )
           => ( ? [Ch3: secrecy_chanID] :
                  ( ( out_ex985543062Single @ P @ Ch3 @ E )
                  & ( member @ secrecy_chanID @ Ch3 @ M2 )
                  & ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) ) )
             => ~ ( eoutM @ PQ @ M2 @ E ) ) ) ) ) ) ).

% TBtheorem5b_notP1
thf(fact_191_eout__know__nonKS__k,axiom,
    ! [M: secrecy_Keys,A2: secrecy_specID] :
      ( ~ ( member @ secrecy_Keys @ M @ ( specKeys @ A2 ) )
     => ( ( eout @ A2 @ ( secrecy_kE @ M ) )
       => ( ( knowle1667810483orrect @ A2 @ ( secrecy_kKS @ M ) )
         => ( knowle1437066798e_know @ A2 @ ( secrecy_kKS @ M ) ) ) ) ) ).

% eout_know_nonKS_k
thf(fact_192_eoutKnowCorrect__L1k,axiom,
    ! [C4: secrecy_specID,M: secrecy_Keys] :
      ( ( knowle1667810483orrect @ C4 @ ( secrecy_kKS @ M ) )
     => ( ( eout @ C4 @ ( secrecy_kE @ M ) )
       => ( ( member @ secrecy_Keys @ M @ ( specKeys @ C4 ) )
          | ( knowle1437066798e_know @ C4 @ ( secrecy_kKS @ M ) ) ) ) ) ).

% eoutKnowCorrect_L1k
thf(fact_193_not__know__k__not__eout,axiom,
    ! [M: secrecy_Keys,A2: secrecy_specID] :
      ( ~ ( member @ secrecy_Keys @ M @ ( specKeys @ A2 ) )
     => ( ~ ( knowle1437066798e_know @ A2 @ ( secrecy_kKS @ M ) )
       => ( ( knowle1667810483orrect @ A2 @ ( secrecy_kKS @ M ) )
         => ~ ( eout @ A2 @ ( secrecy_kE @ M ) ) ) ) ) ).

% not_know_k_not_eout
thf(fact_194_eout__know__k,axiom,
    ! [C4: secrecy_specID,M: secrecy_Keys] :
      ( ( knowle1667810483orrect @ C4 @ ( secrecy_kKS @ M ) )
      = ( ( eout @ C4 @ ( secrecy_kE @ M ) )
        = ( ( member @ secrecy_Keys @ M @ ( specKeys @ C4 ) )
          | ( knowle1437066798e_know @ C4 @ ( secrecy_kKS @ M ) ) ) ) ) ).

% eout_know_k
thf(fact_195_eout__know__nonKS__s,axiom,
    ! [M: secrecy_Secrets,A2: secrecy_specID] :
      ( ~ ( member @ secrecy_Secrets @ M @ ( specSecrets @ A2 ) )
     => ( ( eout @ A2 @ ( secrecy_sE @ M ) )
       => ( ( knowle1667810483orrect @ A2 @ ( secrecy_sKS @ M ) )
         => ( knowle1437066798e_know @ A2 @ ( secrecy_sKS @ M ) ) ) ) ) ).

% eout_know_nonKS_s
thf(fact_196_eoutKnowCorrect__L1s,axiom,
    ! [C4: secrecy_specID,M: secrecy_Secrets] :
      ( ( knowle1667810483orrect @ C4 @ ( secrecy_sKS @ M ) )
     => ( ( eout @ C4 @ ( secrecy_sE @ M ) )
       => ( ( member @ secrecy_Secrets @ M @ ( specSecrets @ C4 ) )
          | ( knowle1437066798e_know @ C4 @ ( secrecy_sKS @ M ) ) ) ) ) ).

% eoutKnowCorrect_L1s
thf(fact_197_TBtheore54b__P,axiom,
    ! [P: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,PQ: secrecy_specID,Q: secrecy_specID] :
      ( ( eoutM @ P @ M2 @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc990227761ionOut @ PQ )
         => ( ? [Ch3: secrecy_chanID] :
                ( ( member @ secrecy_chanID @ Ch3 @ ( out @ Q ) )
                & ( exprChannel @ Ch3 @ E )
                & ~ ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) )
                & ( member @ secrecy_chanID @ Ch3 @ M2 ) )
           => ( eoutM @ PQ @ M2 @ E ) ) ) ) ) ).

% TBtheore54b_P
thf(fact_198_TBtheorem5b__PQ,axiom,
    ! [P: secrecy_specID,M2: set @ secrecy_chanID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ( ( eoutM @ P @ M2 @ E )
        | ( eoutM @ Q @ M2 @ E ) )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc990227761ionOut @ PQ )
         => ( ? [Ch3: secrecy_chanID] :
                ( ( ( member @ secrecy_chanID @ Ch3 @ ( out @ P ) )
                  | ( member @ secrecy_chanID @ Ch3 @ ( out @ Q ) ) )
                & ( member @ secrecy_chanID @ Ch3 @ M2 )
                & ( exprChannel @ Ch3 @ E )
                & ~ ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) ) )
           => ( eoutM @ PQ @ M2 @ E ) ) ) ) ) ).

% TBtheorem5b_PQ
thf(fact_199_TBtheorem45a__P,axiom,
    ! [P: secrecy_specID,E: secrecy_Expression,PQ: secrecy_specID,Q: secrecy_specID] :
      ( ( eout @ P @ E )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc990227761ionOut @ PQ )
         => ( ? [Ch3: secrecy_chanID] :
                ( ( member @ secrecy_chanID @ Ch3 @ ( out @ P ) )
                & ( exprChannel @ Ch3 @ E )
                & ~ ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) ) )
           => ( eout @ PQ @ E ) ) ) ) ) ).

% TBtheorem45a_P
thf(fact_200_eout__def,axiom,
    ( eout
    = ( ^ [SP: secrecy_specID,E2: secrecy_Expression] :
        ? [Ch2: secrecy_chanID] :
          ( ( member @ secrecy_chanID @ Ch2 @ ( out @ SP ) )
          & ( exprChannel @ Ch2 @ E2 ) ) ) ) ).

% eout_def
thf(fact_201_eoutM__def,axiom,
    ( eoutM
    = ( ^ [SP: secrecy_specID,M3: set @ secrecy_chanID,E2: secrecy_Expression] :
        ? [Ch2: secrecy_chanID] :
          ( ( member @ secrecy_chanID @ Ch2 @ ( out @ SP ) )
          & ( member @ secrecy_chanID @ Ch2 @ M3 )
          & ( exprChannel @ Ch2 @ E2 ) ) ) ) ).

% eoutM_def
thf(fact_202_out__exprChannelSet__def,axiom,
    ( out_exprChannelSet
    = ( ^ [SP: secrecy_specID,ChSet2: set @ secrecy_chanID,E2: secrecy_Expression] :
          ( ! [X6: secrecy_chanID] :
              ( ( member @ secrecy_chanID @ X6 @ ChSet2 )
             => ( ( member @ secrecy_chanID @ X6 @ ( out @ SP ) )
                & ( exprChannel @ X6 @ E2 ) ) )
          & ! [X6: secrecy_chanID] :
              ( ( ~ ( member @ secrecy_chanID @ X6 @ ChSet2 )
                & ( member @ secrecy_chanID @ X6 @ ( out @ SP ) ) )
             => ~ ( exprChannel @ X6 @ E2 ) ) ) ) ) ).

% out_exprChannelSet_def
thf(fact_203_out__exprChannelSingle__def,axiom,
    ( out_ex985543062Single
    = ( ^ [SP: secrecy_specID,Ch2: secrecy_chanID,E2: secrecy_Expression] :
          ( ( member @ secrecy_chanID @ Ch2 @ ( out @ SP ) )
          & ( exprChannel @ Ch2 @ E2 )
          & ! [X6: secrecy_chanID,T: nat] :
              ( ( ( member @ secrecy_chanID @ X6 @ ( out @ SP ) )
                & ( X6 != Ch2 ) )
             => ~ ( exprChannel @ X6 @ E2 ) ) ) ) ) ).

% out_exprChannelSingle_def
thf(fact_204_correctCompositionOut__prop1,axiom,
    ! [PQ: secrecy_specID,P: secrecy_specID,Q: secrecy_specID,X: secrecy_chanID] :
      ( ( ( subcomponents @ PQ )
        = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
     => ( ( correc990227761ionOut @ PQ )
       => ( ( member @ secrecy_chanID @ X @ ( out @ PQ ) )
         => ( ( member @ secrecy_chanID @ X @ ( out @ P ) )
            | ( member @ secrecy_chanID @ X @ ( out @ Q ) ) ) ) ) ) ).

% correctCompositionOut_prop1
thf(fact_205_TBtheorem5a__PQ,axiom,
    ! [P: secrecy_specID,E: secrecy_Expression,Q: secrecy_specID,PQ: secrecy_specID] :
      ( ( ( eout @ P @ E )
        | ( eout @ Q @ E ) )
     => ( ( ( subcomponents @ PQ )
          = ( insert @ secrecy_specID @ P @ ( insert @ secrecy_specID @ Q @ ( bot_bot @ ( set @ secrecy_specID ) ) ) ) )
       => ( ( correc990227761ionOut @ PQ )
         => ( ? [Ch3: secrecy_chanID] :
                ( ( ( member @ secrecy_chanID @ Ch3 @ ( out @ P ) )
                  | ( member @ secrecy_chanID @ Ch3 @ ( out @ Q ) ) )
                & ( exprChannel @ Ch3 @ E )
                & ~ ( member @ secrecy_chanID @ Ch3 @ ( loc @ PQ ) ) )
           => ( eout @ PQ @ E ) ) ) ) ) ).

% TBtheorem5a_PQ
thf(fact_206_outStream__def,axiom,
    ( outStream
    = ( ^ [X6: secrecy_specID] :
          ( ^ [Y6: set @ secrecy_chanID,Z: set @ secrecy_chanID] : ( Y6 = Z )
          @ ( out @ X6 ) ) ) ) ).

% outStream_def
thf(fact_207_adv__not__know2,axiom,
    ! [P: secrecy_specID,A2: secrecy_specID,M: secrecy_Secrets] :
      ( ( ord_less_eq @ ( set @ secrecy_chanID ) @ ( out @ P ) @ ( ins @ A2 ) )
     => ( ~ ( knowle1437066798e_know @ A2 @ ( secrecy_sKS @ M ) )
       => ~ ( eout @ P @ ( secrecy_sE @ M ) ) ) ) ).

% adv_not_know2
thf(fact_208_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_209_subset__antisym,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ A2 )
       => ( A2 = B2 ) ) ) ).

% subset_antisym
thf(fact_210_subsetI,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ! [X5: A] :
          ( ( member @ A @ X5 @ A2 )
         => ( member @ A @ X5 @ B2 ) )
     => ( ord_less_eq @ ( set @ A ) @ A2 @ B2 ) ) ).

% subsetI
thf(fact_211_empty__subsetI,axiom,
    ! [A: $tType,A2: set @ A] : ( ord_less_eq @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ A2 ) ).

% empty_subsetI
thf(fact_212_subset__empty,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ ( bot_bot @ ( set @ A ) ) )
      = ( A2
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% subset_empty
thf(fact_213_insert__subset,axiom,
    ! [A: $tType,X: A,A2: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( insert @ A @ X @ A2 ) @ B2 )
      = ( ( member @ A @ X @ B2 )
        & ( ord_less_eq @ ( set @ A ) @ A2 @ B2 ) ) ) ).

% insert_subset
thf(fact_214_Un__subset__iff,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) @ C4 )
      = ( ( ord_less_eq @ ( set @ A ) @ A2 @ C4 )
        & ( ord_less_eq @ ( set @ A ) @ B2 @ C4 ) ) ) ).

% Un_subset_iff
thf(fact_215_singleton__insert__inj__eq,axiom,
    ! [A: $tType,B3: A,A3: A,A2: set @ A] :
      ( ( ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ A3 @ A2 ) )
      = ( ( A3 = B3 )
        & ( ord_less_eq @ ( set @ A ) @ A2 @ ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% singleton_insert_inj_eq
thf(fact_216_singleton__insert__inj__eq_H,axiom,
    ! [A: $tType,A3: A,A2: set @ A,B3: A] :
      ( ( ( insert @ A @ A3 @ A2 )
        = ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( A3 = B3 )
        & ( ord_less_eq @ ( set @ A ) @ A2 @ ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% singleton_insert_inj_eq'
thf(fact_217_Un__mono,axiom,
    ! [A: $tType,A2: set @ A,C4: set @ A,B2: set @ A,D3: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ C4 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ D3 )
       => ( ord_less_eq @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) @ ( sup_sup @ ( set @ A ) @ C4 @ D3 ) ) ) ) ).

% Un_mono
thf(fact_218_Un__least,axiom,
    ! [A: $tType,A2: set @ A,C4: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ C4 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ C4 )
       => ( ord_less_eq @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) @ C4 ) ) ) ).

% Un_least
thf(fact_219_Un__upper1,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] : ( ord_less_eq @ ( set @ A ) @ A2 @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ).

% Un_upper1
thf(fact_220_Un__upper2,axiom,
    ! [A: $tType,B2: set @ A,A2: set @ A] : ( ord_less_eq @ ( set @ A ) @ B2 @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ).

% Un_upper2
thf(fact_221_Un__absorb1,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( sup_sup @ ( set @ A ) @ A2 @ B2 )
        = B2 ) ) ).

% Un_absorb1
thf(fact_222_Un__absorb2,axiom,
    ! [A: $tType,B2: set @ A,A2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ B2 @ A2 )
     => ( ( sup_sup @ ( set @ A ) @ A2 @ B2 )
        = A2 ) ) ).

% Un_absorb2
thf(fact_223_subset__UnE,axiom,
    ! [A: $tType,C4: set @ A,A2: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ C4 @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
     => ~ ! [A6: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A6 @ A2 )
           => ! [B6: set @ A] :
                ( ( ord_less_eq @ ( set @ A ) @ B6 @ B2 )
               => ( C4
                 != ( sup_sup @ ( set @ A ) @ A6 @ B6 ) ) ) ) ) ).

% subset_UnE
thf(fact_224_subset__Un__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A4: set @ A,B5: set @ A] :
            ( ( sup_sup @ ( set @ A ) @ A4 @ B5 )
            = B5 ) ) ) ).

% subset_Un_eq
thf(fact_225_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B3: A,A3: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ A3 @ B3 )
           => ( A3 = B3 ) ) ) ) ).

% dual_order.antisym
thf(fact_226_dual__order_Oeq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y6: A,Z: A] : ( Y6 = Z ) )
        = ( ^ [A5: A,B7: A] :
              ( ( ord_less_eq @ A @ B7 @ A5 )
              & ( ord_less_eq @ A @ A5 @ B7 ) ) ) ) ) ).

% dual_order.eq_iff
thf(fact_227_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ C @ B3 )
           => ( ord_less_eq @ A @ C @ A3 ) ) ) ) ).

% dual_order.trans
thf(fact_228_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P: A > A > $o,A3: A,B3: A] :
          ( ! [A7: A,B8: A] :
              ( ( ord_less_eq @ A @ A7 @ B8 )
             => ( P @ A7 @ B8 ) )
         => ( ! [A7: A,B8: A] :
                ( ( P @ B8 @ A7 )
               => ( P @ A7 @ B8 ) )
           => ( P @ A3 @ B3 ) ) ) ) ).

% linorder_wlog
thf(fact_229_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A3: A] : ( ord_less_eq @ A @ A3 @ A3 ) ) ).

% dual_order.refl
thf(fact_230_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y: A,Z2: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z2 )
           => ( ord_less_eq @ A @ X @ Z2 ) ) ) ) ).

% order_trans
thf(fact_231_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A3: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ A3 )
           => ( A3 = B3 ) ) ) ) ).

% order_class.order.antisym
thf(fact_232_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( B3 = C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_233_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A3: A,B3: A,C: A] :
          ( ( A3 = B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_234_order__class_Oorder_Oeq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y6: A,Z: A] : ( Y6 = Z ) )
        = ( ^ [A5: A,B7: A] :
              ( ( ord_less_eq @ A @ A5 @ B7 )
              & ( ord_less_eq @ A @ B7 @ A5 ) ) ) ) ) ).

% order_class.order.eq_iff
thf(fact_235_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ( ( ord_less_eq @ A @ X @ Y )
            = ( X = Y ) ) ) ) ).

% antisym_conv
thf(fact_236_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y: A,Z2: A] :
          ( ( ( ord_less_eq @ A @ X @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z2 ) )
         => ( ( ( ord_less_eq @ A @ Y @ X )
             => ~ ( ord_less_eq @ A @ X @ Z2 ) )
           => ( ( ( ord_less_eq @ A @ X @ Z2 )
               => ~ ( ord_less_eq @ A @ Z2 @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z2 @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z2 )
                   => ~ ( ord_less_eq @ A @ Z2 @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z2 @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_237_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% order.trans
thf(fact_238_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y )
         => ( ord_less_eq @ A @ Y @ X ) ) ) ).

% le_cases
thf(fact_239_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X: A,Y: A] :
          ( ( X = Y )
         => ( ord_less_eq @ A @ X @ Y ) ) ) ).

% eq_refl
thf(fact_240_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
          | ( ord_less_eq @ A @ Y @ X ) ) ) ).

% linear
thf(fact_241_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ X )
           => ( X = Y ) ) ) ) ).

% antisym
thf(fact_242_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y6: A,Z: A] : ( Y6 = Z ) )
        = ( ^ [X6: A,Y7: A] :
              ( ( ord_less_eq @ A @ X6 @ Y7 )
              & ( ord_less_eq @ A @ Y7 @ X6 ) ) ) ) ) ).

% eq_iff
thf(fact_243_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B )
        & ( ord @ A ) )
     => ! [A3: A,B3: A,F: A > B,C: B] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ( F @ B3 )
              = C )
           => ( ! [X5: A,Y5: A] :
                  ( ( ord_less_eq @ A @ X5 @ Y5 )
                 => ( ord_less_eq @ B @ ( F @ X5 ) @ ( F @ Y5 ) ) )
             => ( ord_less_eq @ B @ ( F @ A3 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_244_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B )
        & ( ord @ A ) )
     => ! [A3: A,F: B > A,B3: B,C: B] :
          ( ( A3
            = ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C )
           => ( ! [X5: B,Y5: B] :
                  ( ( ord_less_eq @ B @ X5 @ Y5 )
                 => ( ord_less_eq @ A @ ( F @ X5 ) @ ( F @ Y5 ) ) )
             => ( ord_less_eq @ A @ A3 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_245_order__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 )
        & ( order @ A ) )
     => ! [A3: A,B3: A,F: A > C3,C: C3] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ C3 @ ( F @ B3 ) @ C )
           => ( ! [X5: A,Y5: A] :
                  ( ( ord_less_eq @ A @ X5 @ Y5 )
                 => ( ord_less_eq @ C3 @ ( F @ X5 ) @ ( F @ Y5 ) ) )
             => ( ord_less_eq @ C3 @ ( F @ A3 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_246_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B )
        & ( order @ A ) )
     => ! [A3: A,F: B > A,B3: B,C: B] :
          ( ( ord_less_eq @ A @ A3 @ ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C )
           => ( ! [X5: B,Y5: B] :
                  ( ( ord_less_eq @ B @ X5 @ Y5 )
                 => ( ord_less_eq @ A @ ( F @ X5 ) @ ( F @ Y5 ) ) )
             => ( ord_less_eq @ A @ A3 @ ( F @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_247_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F5: A > B,G2: A > B] :
            ! [X6: A] : ( ord_less_eq @ B @ ( F5 @ X6 ) @ ( G2 @ X6 ) ) ) ) ) ).

% le_fun_def
thf(fact_248_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ! [F: A > B,G: A > B] :
          ( ! [X5: A] : ( ord_less_eq @ B @ ( F @ X5 ) @ ( G @ X5 ) )
         => ( ord_less_eq @ ( A > B ) @ F @ G ) ) ) ).

% le_funI
thf(fact_249_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ! [F: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funE
thf(fact_250_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ! [F: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funD
thf(fact_251_Collect__mono__iff,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) )
      = ( ! [X6: A] :
            ( ( P @ X6 )
           => ( Q @ X6 ) ) ) ) ).

% Collect_mono_iff
thf(fact_252_set__eq__subset,axiom,
    ! [A: $tType] :
      ( ( ^ [Y6: set @ A,Z: set @ A] : ( Y6 = Z ) )
      = ( ^ [A4: set @ A,B5: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A4 @ B5 )
            & ( ord_less_eq @ ( set @ A ) @ B5 @ A4 ) ) ) ) ).

% set_eq_subset
thf(fact_253_subset__trans,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ C4 )
       => ( ord_less_eq @ ( set @ A ) @ A2 @ C4 ) ) ) ).

% subset_trans
thf(fact_254_Collect__mono,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X5: A] :
          ( ( P @ X5 )
         => ( Q @ X5 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) ) ) ).

% Collect_mono
thf(fact_255_subset__refl,axiom,
    ! [A: $tType,A2: set @ A] : ( ord_less_eq @ ( set @ A ) @ A2 @ A2 ) ).

% subset_refl

% Type constructors (24)
thf(tcon_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice @ $o ).

thf(tcon_Set_Oset___Lattices_Obounded__lattice_1,axiom,
    ! [A8: $tType] : ( bounded_lattice @ ( set @ A8 ) ) ).

thf(tcon_fun___Lattices_Obounded__lattice_2,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( bounded_lattice @ A9 )
     => ( bounded_lattice @ ( A8 > A9 ) ) ) ).

thf(tcon_fun___Lattices_Obounded__semilattice__sup__bot,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( bounded_lattice @ A9 )
     => ( bounde1808546759up_bot @ ( A8 > A9 ) ) ) ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( preorder @ A9 )
     => ( preorder @ ( A8 > A9 ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( order @ A9 )
     => ( order @ ( A8 > A9 ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( ord @ A9 )
     => ( ord @ ( A8 > A9 ) ) ) ).

thf(tcon_fun___Orderings_Obot,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( bot @ A9 )
     => ( bot @ ( A8 > A9 ) ) ) ).

thf(tcon_Nat_Onat___Orderings_Opreorder_3,axiom,
    preorder @ nat ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat ).

thf(tcon_Nat_Onat___Orderings_Oorder_4,axiom,
    order @ nat ).

thf(tcon_Nat_Onat___Orderings_Oord_5,axiom,
    ord @ nat ).

thf(tcon_Nat_Onat___Orderings_Obot_6,axiom,
    bot @ nat ).

thf(tcon_Set_Oset___Lattices_Obounded__semilattice__sup__bot_7,axiom,
    ! [A8: $tType] : ( bounde1808546759up_bot @ ( set @ A8 ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_8,axiom,
    ! [A8: $tType] : ( preorder @ ( set @ A8 ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_9,axiom,
    ! [A8: $tType] : ( order @ ( set @ A8 ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_10,axiom,
    ! [A8: $tType] : ( ord @ ( set @ A8 ) ) ).

thf(tcon_Set_Oset___Orderings_Obot_11,axiom,
    ! [A8: $tType] : ( bot @ ( set @ A8 ) ) ).

thf(tcon_HOL_Obool___Lattices_Obounded__semilattice__sup__bot_12,axiom,
    bounde1808546759up_bot @ $o ).

thf(tcon_HOL_Obool___Orderings_Opreorder_13,axiom,
    preorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Olinorder_14,axiom,
    linorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Oorder_15,axiom,
    order @ $o ).

thf(tcon_HOL_Obool___Orderings_Oord_16,axiom,
    ord @ $o ).

thf(tcon_HOL_Obool___Orderings_Obot_17,axiom,
    bot @ $o ).

% Conjectures (1)
thf(conj_0,conjecture,
    ~ ( ine @ pq @ ( secrecy_kE @ key ) ) ).

%------------------------------------------------------------------------------
